<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use Illuminate\Support\Facades\Broadcast;

Broadcast::routes();

Route::get('/', function () {
    return view('front.home.index');
})->name('home');

Route::get('/list', function () {
    return view('front.pages.list.index');
});

Route::get('/shopSingle', function () {
    return view('front.pages.shoplist.index');
});
Route::get('/shopList', function () {
    return view('front.pages.shoplist.list');
});

Route::get('/single/{id}', function ($id) {
    $data['id']= $id;
    return view('front.pages.single.index',$data);
});

Route::post('/expert', function () {
    return view('front.pages.extra.index');
});

Route::get('/createAd', function () {
    return view('front.pages.createAd');
});
Route::get('/myAds', function () {
    return view('front.pages.list.myAd');
});
Route::post('/editAd', function () {
    return view('front.pages.editAd');
});
Route::get('/advanceSearch', function () {
    return view('front.pages.advanceSearch');
});
Route::get('/myFabrika', function () {
    return view('front.pages.myFabrika');
});
Route::get('/about', function () {
    return view('front.pages.about');
});
Route::get('/rules', function () {
    return view('front.pages.rules');
});

Route::get('/home', 'HomeController@index')->name('home');
Route::post('signup','UserController@signUp');
Route::post('signin','UserController@signIn');
Route::post('check','UserController@check');
Route::post('resend','UserController@resend');
Route::get('logout','UserController@logout');
Route::get('files','HomeController@retrievingFiles');
Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');
Route::get('testpay',function(){
    return '<a href="fitclub://app/1">return to app</a>';
});