
/**
 * First we will load all of this project's JavaScript dependencies which
 * includes Vue and other libraries. It is a great starting point when
 * building robust, powerful web applications using Vue and Laravel.
 */

require('./bootstrap');

window.Vue = require('vue');
window.VueScrollTo = require('vue-scrollto');
window.persianDate = require('persian-date/dist/persian-date.min')
require('jquery-toast-plugin/dist/jquery.toast.min');

/**
 * Next, we will create a fresh Vue application instance and attach it to
 * the page. Then, you may begin adding components to this application
 * or customize the JavaScript scaffolding to fit your unique needs.
 */
// master
Vue.component('modals', require('./components/master/modals'));
Vue.component('site-header', require('./components/master/header'));
Vue.component('site-footer', require('./components/master/footer'));
Vue.component('advance-search', require('./components/master/advanceSearch'));
Vue.component('my-fabrika', require('./components/master/myFabrika'));
// create
Vue.component('create-ad', require('./components/master/createAd'));
Vue.component('edit-ad', require('./components/master/editAd'));
// home
Vue.component('main-section', require('./components/home/mainSection.vue'));
Vue.component('main-ad', require('./components/home/mainAd.vue'));
// list
Vue.component('list-main', require('./components/list/main.vue'));
Vue.component('shop-main', require('./components/list/mainShop'));
Vue.component('shop-list', require('./components/list/listShop'));
Vue.component('my-ads', require('./components/list/myAds.vue'));
// single
Vue.component('single', require('./components/single/single.vue'));
// expert
Vue.component('expert', require('./components/expert/single.vue'));

const app = new Vue({
    el: '#app'
});

Vue.filter('priceFormat',(price)=>{
    if(price){
        return price.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    }
})
Vue.filter('persian_date',(date)=>{
    date = date.replace(/-/g,'/')
    let d = new Date(date)
    return new persianDate(d.getTime()).format('DD MMMM YY')
})