<?php
Route::group(['middleware' => ['web','auth','acl'], 'prefix' => 'admin','as' => 'admin'], function()
{
    Route::group(['middleware' => 'web', 'prefix' => 'team', 'namespace' => 'Modules\Team\Http\Controllers' , 'as'=>'.team'], function()
    {
        Route::group(['middleware' => 'web', 'prefix' => 'list','as' => '.list' ], function()
        {
            Route::get('/', 'TeamController@index');
            Route::get('/delete','TeamController@destroy')->name('.delete');
            Route::get('/create','TeamController@create')->name('.create');
            Route::post('store', 'TeamController@store')->name('.store');
            Route::get('/edit','TeamController@edit')->name('.edit');
            Route::post('update/{id}', 'TeamController@update')->name('.update');
        });
        Route::group(['middleware' => 'web', 'prefix' => 'social','as' => '.social' ], function()
        {
            Route::get('/', 'SocialNetworksController@index');
            Route::get('/create','SocialNetworksController@create')->name('.create');
            Route::post('store', 'SocialNetworksController@store')->name('.store');
            Route::get('/edit','SocialNetworksController@edit')->name('.edit');
            Route::post('update/{id}', 'SocialNetworksController@update')->name('.update');
        });
    });
});
//front-end routes
Route::group([ 'prefix' => 'team', 'namespace' => 'Modules\Team\Http\Controllers','middleware' => 'web'], function()
{
    Route::get('/show','TeamController@show')->name('.show');
    Route::get('/social-networks','SocialNetworksController@show');

});
