<?php

namespace Modules\Team\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Modules\Team\Entities\SocialNetwork;
use Modules\Team\Entities\Team;
use Nwidart\Modules\Facades\Module;
use Yajra\DataTables\DataTables;
use Yajra\DataTables\Html\Builder;
use Modules\Core\Http\Controllers\BaseController;



class SocialNetworksController extends BaseController
{
    protected $htmlBuilder;
    public function __construct(Builder $htmlBuilder)
    {
        $this->htmlBuilder = $htmlBuilder;
        $this->htmlBuilder->parameters([
            'paging' => true,
            'searching' => true,
            'info' => false,
            'searchDelay' => 350,
            'language' => [
                'url' => Module::asset('core:datatable.json')
            ],
        ]);
        Parent::__construct();
    }
    /**
     * Display a listing of the resource.
     * @param Request $request
     * @return Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            return DataTables::of(SocialNetwork::select(['id','telegram','google','twitter','instagram','facebook', 'created_at', 'updated_at']))
                ->addColumn('operation', function($team) {
                    return parent::redirectAction('social/edit','ویرایش','warning mr-1');
                })
                ->rawColumns(['operation','display'])
                ->make(true);
        }
        $object = 'شبکه اجتماعی';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' =>'google', 'name' => 'google', 'title' => 'google+'])
            ->addColumn(['data' => 'telegram', 'name' => 'telegram', 'title' => 'telegram'])
            ->addColumn(['data' => 'twitter', 'name' => 'twitter', 'title' => 'twitter'])
            ->addColumn(['data' => 'instagram', 'name' => 'instagram', 'title' => 'instagram'])
            ->addColumn(['data' => 'facebook', 'name' => 'facebook', 'title' => 'facebook'])
            ->addColumn(['data' => 'updated_at', 'name' => 'updated_at', 'title' => 'ویرایش'])
            ->addColumn(['data' => 'operation', 'name' => 'operation', 'title' => 'عملیات']);
        return view('core::shared.datatable', compact(['html','object']));
    }
    /**
     * Show the form for creating a new resource.
     * @return Response
     */
    public function create()
    {
        $data['model'] = new SocialNetwork();
        $data['route_action'] = 'team.social.store';
        return view('core::shared.add',$data);
    }
    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function store(Request $request)
    {
        $check= SocialNetwork::find(1);
        if($check!=null){
            SocialNetwork::find((1))->update($request->all());
        }else{
            SocialNetwork::create($request->all());
        }
        return redirect()->route('admin.team.social');
    }
    /**
     * Show the specified resource.
     * @return Response
     */
    public function show()
    {
        $data=SocialNetwork::all();
        return response()->json([
            'data'  => $data,
            'message'=>'ok',
            'status' => 200
        ]);
    }
    /**
     * Show the form for editing the specified resource.
     * @param Request $request
     * @return Response
     */
    public function edit(Request $request)
    {
        $data['route_action'] = 'team.social.update';
        $data['data']=SocialNetwork::find(1);
        return view('core::shared.edit', $data);
    }
    /**
     * Update the specified resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function update(Request $request)
    {
        SocialNetwork::find((1))->update($request->all());
        return redirect()->route('admin.team.social');
    }
}
