<?php

namespace Modules\Team\Entities;

use Elasticquent\ElasticquentTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Core\Entities\Attachment;

class Team extends Model
{
    use ElasticquentTrait;
    use SoftDeletes;
    protected $fillable = ['name','education','description'];
    protected $appends = ['attachments'];

    function attachments(){
        return $this->morphMany(Attachment::class,'attachmentable');
    }
    public function getAttachmentsAttribute()
    {
        return $this->attachments()->get();
    }
    public $adminFields=[
        'image'=>[
            'type'=>'photo',
            'fa_name'=>'عکس ',
            'col'=>12,
            'required'=>false,
            'data'=>[]
        ],
        'name'=>[
            'type'=>'string',
            'fa_name'=>'نام',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'education'=>[
            'type'=>'string',
            'fa_name'=>'تحصیلات',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'description'=>[
            'type'=>'string',
            'fa_name'=>'توضیحات',
            'col'=>12,
            'required'=>false,
            'data'=>[]
        ],

    ];
}
