<?php

namespace Modules\Slider\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;

use Modules\Core\Http\Controllers\BaseController;
use Modules\Slider\Entities\Slider;
use Modules\Slider\Entities\SliderItem;
use Nwidart\Modules\Facades\Module;
use Yajra\DataTables\DataTables;
use Yajra\DataTables\Html\Builder;

class ItemController extends BaseController
{
    protected $htmlBuilder;
    public function __construct(Builder $htmlBuilder)
    {
        $this->htmlBuilder = $htmlBuilder;
        $this->htmlBuilder->parameters([
            'paging' => true,
            'searching' => true,
            'info' => false,
            'searchDelay' => 350,
            'language' => [
                'url' => Module::asset('core:datatable.json')
            ],
        ]);
        Parent::__construct();
    }

    public function index(Request $request)
    {
        if ($request->ajax()) {
            return DataTables::of(Slider::find($request->id)->subs()->select(['id','title','description','display','position','created_at','updated_at']))
                ->addColumn('operation', function($slider) {
                    return parent::redirectAction('delete/'.$slider->id,'حذف','danger mr-1')
                        .parent::redirectAction('edit/'.$slider->id,'ویرایش','warning mr-1');
                })
                ->editColumn('display', function($slider) {
                    if($slider->display==1){
                        return "<span class='btn btn-success'> فعال</span>";
                    }elseif($slider->display==0){
                        return "<span class='btn btn-danger'>غیرفعال</span>";
                    }
                })
                ->rawColumns(['operation','display'])
                ->make(true);
        }
        $object = 'اسلایدها';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' => 'title', 'name' => 'title', 'title' => 'عنوان'])
            ->addColumn(['data' => 'description', 'name' => 'description', 'title' => 'توضیحات'])
            ->addColumn(['data' => 'display', 'name' => 'display', 'title' => 'نمایش'])
            ->addColumn(['data' => 'position', 'name' => 'position', 'title' => 'موقعیت'])
            ->addColumn(['data' => 'created_at', 'name' => 'created_at', 'title' => 'ثبت'])
            ->addColumn(['data' => 'updated_at', 'name' => 'updated_at', 'title' => 'ویرایش'])
            ->addColumn(['data' => 'operation', 'name' => 'operation', 'title' => 'عملیات']);
        return view('core::shared.datatable', compact(['html','object']));
    }
    /**
     * Show the form for creating a new resource.
     * @return Response
     */
    public function add($id)
    {
        $data['model'] = new SliderItem();
        $data['route_action'] = 'slider.item.store';
        $data['params'] = ['id'=>$id];
        $data['id']=$id;
        return view('core::shared.add',$data);
    }
    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function store(Request $request)
    {
        $subs = Slider::find($request->id)->subs()->create($request->all());
        Parent::attachmentProcess($request,$subs);
        return redirect()->route('admin.slider.item' , ['id' => $request->id]);
    }
    /**
     * Show the form for editing the specified resource.
     * @param Request $request
     * @return Response
     */
    public function edit(Request $request)
    {
        $data['route_action'] ='slider.item.update';
        $data['data']=SliderItem::find($request->id);
        return view('core::shared.edit', $data);
    }
    /**
     * Update the specified resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function update(Request $request)
    {
        $item= SliderItem::find(($request->id));
        $parent_id =$item->slider_id;
        SliderItem::find(($request->id))->update($request->all());
        return redirect()->route('admin.slider.item' , ['id' => $parent_id]);
    }
    /**
     * Remove the specified resource from storage.
     * @param  Request $request
     * @return Response
     */
    public function destroy(Request $request)
    {
        $item=SliderItem::find($request->id);
        $parent_id= $item->slider_id;
        SliderItem::find($request->id)->delete();
        return redirect('admin/slider/item/'.$parent_id);
    }

    static public function display(){
        return ['1'=>'فعال','0' => 'غیر فعال'];
    }

}
