<?php

namespace Modules\Slider\Entities;

use Elasticquent\ElasticquentTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Slider extends Model
{
    use ElasticquentTrait;
    use SoftDeletes;
    protected $fillable = ['title','description','slug'];
    public function subs()
    {
        return $this->hasMany(SliderItem::class, 'slider_id');
    }
    public $adminFields=[

        'title'=>[
            'type'=>'string',
            'fa_name'=>'عنوان',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'description'=>[
            'type'=>'string',
            'fa_name'=>'توضیحات',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'slug'=>[
            'type'=>'string',
            'fa_name'=>'slug',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],

    ];
}
