<?php

namespace Modules\Shop\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\BroadcastMessage;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Modules\Core\Entities\User;
use NotificationChannels\Gcm\GcmChannel;
use NotificationChannels\Gcm\GcmMessage;
use NotificationChannels\WebPush\PushSubscription;
use NotificationChannels\WebPush\WebPushChannel;
use NotificationChannels\WebPush\WebPushMessage;

class test extends Notification
{
    use Queueable;

    public $user=null;
    public $adv_id=null;
    public $shop_id=null;

    public function __construct(User $user,$adv_id,$shop_id)
    {
        $this->user=$user;
        $this->adv_id=$adv_id;
        $this->shop_id=$shop_id;
    }

    /**
     * Get the notification's delivery channels.
     * @param  mixed  $notifiable
     * @return array
     */

    public function via($notifiable)
    {
        return [WebPushChannel::class,'database','broadcast'];
    }

    public function toWebPush($notifiable, $notification)
    {
        return (new WebPushMessage)
            ->title('New Advertisement!')
//            ->icon('/approved-icon.png')
            ->body('Your account was approved!')
            ->data(['id' => $notification->id,'advertisement_id'=>$this->adv_id ,'shop_id'=>$this->shop_id]);
        // ->badge()
        // ->dir()
        // ->image()
        // ->lang()
        // ->renotify()
        // ->requireInteraction()
        // ->tag()
        // ->vibrate()
    }

    public function toBroadcast($notifiable)
    {
        return new BroadcastMessage([
            'user_id'=>$this->user->id,
        ]);
    }
    public function toDatabase($notifiable)
    {
        return new BroadcastMessage([
            'user_id'=>$this->user->id,
        ]);
    }
}
