<?php

Route::group(['middleware' => ['web','auth','acl'], 'prefix' => 'admin','as' => 'admin'], function()
{
    Route::group(['middleware' => 'web', 'prefix' => 'shop', 'namespace' => 'Modules\Shop\Http\Controllers' , 'as'=>'.shop'], function()
    {
        Route::group(['middleware' => 'web', 'prefix' => 'list','as' => '.list' ], function()
        {
            Route::get('/', 'ShopController@index');
            Route::get('/delete','ShopController@destroy')->name('.delete');
            Route::get('/create','ShopController@add')->name('.create');
            Route::post('store', 'ShopController@store')->name('.store');
            Route::get('/edit/{id}','ShopController@edit')->name('.edit');
            Route::post('update/{id}', 'ShopController@update')->name('.update');

            Route::group(['middleware' => 'web', 'prefix' => 'attachments','as' => '.attachments'], function() {
                Route::get('/{id}','AttachmentController@index');
                Route::get('/{id}/create', 'AttachmentController@create')->name('.create');
                Route::get('/download/{id}', 'AttachmentController@download')->name('.download');
                Route::get('/delete/{id}', 'AttachmentController@destroy')->name('.delete');
                Route::post('store/{id}','AttachmentController@store')->name('.store');
            });
            Route::group(['middleware' => 'web', 'prefix' => 'report','as' => '.report'], function()
            {
                Route::get('/','ReportController@index');
                Route::get('/delete/{id}','ReportController@destroy')->name('.delete');
            });
        });
    });
    Route::group(['middleware' => 'web', 'prefix' => 'shop_request', 'namespace' => 'Modules\Shop\Http\Controllers' , 'as'=>'.shop_request'], function()
    {
        Route::group(['middleware' => 'web', 'prefix' => 'list','as' => '.list' ], function()
        {
            Route::get('/', 'ShoprequestController@index');
            Route::get('/delete','ShoprequestController@destroy')->name('.delete');
            Route::get('/show/{id}','ShoprequestController@show')->name('.show');
            Route::get('update/{id}', 'ShoprequestController@update')->name('.update');
        });
    });
});
//front-end routes
Route::group([ 'prefix' => 'shop', 'namespace' => 'Modules\Shop\Http\Controllers','middleware' => 'web'], function()
{
    Route::post('/show','ShopController@show')->name('.show');
    Route::post('/show-adv','ShopController@showAdv')->name('.showAdv');
    Route::post('/show-all', 'ShopController@showAll')->name('.showAll');

});



Route::middleware(['auth:api'])->group(function () {
    Route::group([ 'prefix' => 'shop', 'namespace' => 'Modules\Shop\Http\Controllers'], function()
    {
        Route::post('/create','ShopController@create')->name('.create');
        Route::post('/update','ShopController@updateShop');
        Route::post('/delete-attachment','ShopController@shopDeleteAttachment');

        Route::post('/report/delete','ReportController@delete');
        Route::post('/report/store','ReportController@store');
        Route::post('/report/update','ReportController@update');


        Route::group([ 'prefix' => 'comment'], function()
        {
            Route::post('/create','ShopController@create');
            Route::post('/delete','ShopController@delete');
        });
    });

});