<?php

namespace Modules\Shop\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use Modules\Core\Entities\Attachment;
use Modules\Core\Entities\CityTranslation;
use Modules\Shop\Entities\Shop;
use Modules\Shop\Entities\Shoprequest;
use Yajra\DataTables\DataTables;
use Yajra\DataTables\Html\Builder;
use Nwidart\Modules\Facades\Module;
use Modules\Core\Http\Controllers\BaseController;

class ShoprequestController extends BaseController
{
    protected $htmlBuilder;
    public function __construct(Builder $htmlBuilder)
    {
        $this->htmlBuilder = $htmlBuilder;
        $this->htmlBuilder->parameters([
            'paging' => true,
            'searching' => true,
            'info' => false,
            'searchDelay' => 350,
            'language' => [
                'url' => Module::asset('core:datatable.json')
            ],
        ]);
        Parent::__construct();
    }
    public function index(Request $request)
    {
        if ($request->ajax()) {
            return DataTables::of(Shoprequest::
            select(['shop_requests.id'
                ,DB::raw('shops.title as shops_title ')
                ,'shop_requests.type','shop_requests.status','shop_requests.created_at','shop_requests.updated_at'])
                ->join('shops', 'shop_requests.shop_id', '=', 'shops.id')
            )
                ->editColumn('type', function($req) {
                    if($req->type=='silver'){
                        return "<span class='btn btn-primary'>نقره ای</span>";
                    }
                    elseif($req->type=='gold'){
                        return "<span class='btn btn-warning'>طلایی</span>";
                    }
                })
                ->editColumn('status', function($req) {
                    if($req->status==1){
                        return "<span class='btn btn-success'> تایید شده</span>";
                    }elseif($req->status==0){
                        return "<span class='btn btn-danger'>در انتظار تایید</span>";
                    }
                })
                ->addColumn('operation', function($req){
                    return parent::redirectAction('list/delete?id='.$req->id,'حذف','danger mr-1')
                        .parent::redirectAction('list/show/'.$req->id,'مشاهده فروشگاه','info mr-1');
                })
                ->rawColumns(['operation','status','type','owner'])
                ->make(true);
        }
        $object = 'درخواست ها ';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' =>'shops_title', 'name' => 'shops.title', 'title' => 'عنوان فروشگاه'])
            ->addColumn(['data' => 'type', 'name' => 'type', 'title' => 'نوع درخواست'])
            ->addColumn(['data' => 'status', 'name' => 'status', 'title' => 'وضغیت'])
            ->addColumn(['data' => 'created_at', 'name' => 'created_at', 'title' => 'ثبت'])
            ->addColumn(['data' => 'updated_at', 'name' => 'updated_at', 'title' => 'ویرایش'])
            ->addColumn(['data' => 'operation', 'name' => 'operation', 'title' => 'عملیات']);
        return view('core::shared.datatable', compact(['html','object']));
    }
    /**
     * Remove the specified resource from storage.
     * @param Request $request
     * @return Response
     */
    public function destroy(Request $request)
    {
        Shoprequest::find($request->id)->delete();
        return redirect('admin/shop_request/list');
    }
    public function show(Request $request)
    {
        $shop_id=Shoprequest::find($request->id)->shop_id;
        $data=Shop::where('id',$shop_id)->with('attachments')->first();
        $city_id=$data->city_id;
        $data['city']=CityTranslation::where('id',$city_id)->first();
        $data['req_id']=$request->id;

        return view('shop::detail',['data'=>$data]);
    }
    public function add()
    {
        $data['model'] = new Shop();
        $data['route_action'] = 'shop.list.store';
        return view('core::shared.add',$data);
    }


    /**
     * Update the specified resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function update(Request $request)
    {
        $Shoprequest=Shoprequest::find(($request->id));
        $shop_id=$Shoprequest->shop_id;
        $type=$Shoprequest->type;
        $Shoprequest->update(['status'=>1]);
        Shop::find($shop_id)->update(['status'=>1 ,'type'=>$type]);
        return redirect()->route('admin.shop_request.list');
    }

    static public function assignGold($json){
        $request=json_decode($json);
        $data=$request->data;
        $shop_id=$data->shop_id;
        $invoice_id=$request->invoice_id;

        Shoprequest::create(['type'=>'gold','shop_id'=>$shop_id,'status'=>0]);
        Attachment::where('attachmentable_id',$invoice_id)->where('attachmentable_type','Modules\Financial\Entities\Invoice')->update([
            'attachmentable_type' => 'Modules\Shop\Entities\Shop',
            'attachmentable_id' => $shop_id
        ]);
    }
    static public function assignSilver($json){
        $request=json_decode($json);
        $data=$request->data;
        $shop_id=$data->shop_id;
        $invoice_id=$request->invoice_id;
        Shoprequest::create(['type'=>'silver','shop_id'=>$shop_id,'status'=>0]);
        Attachment::where('attachmentable_id',$invoice_id)->where('attachmentable_type','Modules\Financial\Entities\Invoice')->update([
            'attachmentable_type' => 'Modules\Shop\Entities\Shop',
            'attachmentable_id' => $shop_id
        ]);
    }
}