<?php

namespace Modules\Shop\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Modules\Advertisement\Entities\Experience;
use Modules\Shop\Entities\Shop;
use Yajra\DataTables\Html\Builder;
use Nwidart\Modules\Facades\Module;
use Modules\Core\Http\Controllers\BaseController;
use Yajra\DataTables\DataTables;
class ReportController extends BaseController
{
    protected $htmlBuilder;
    public function __construct(Builder $htmlBuilder)
    {
        $this->htmlBuilder = $htmlBuilder;
        $this->htmlBuilder->parameters([
            'paging' => true,
            'searching' => true,
            'info' => false,
            'searchDelay' => 350,
            'language' => [
                'url' => Module::asset('core:datatable.json')
            ],
        ]);
        Parent::__construct();
    }
    public function index(Request $request)
    {

        if ($request->ajax()){
            return DataTables::of(Experience::where('experiencable_type','Modules\Shop\Entities\Shop')
                ->select(['experiences.id',
                    DB::raw('concat(users.fname ," ",users.lname) as users_fullname ')
                    ,DB::raw('shops.title as shops_title ')
                    ,'experiencable_type','experiencable_id','text', 'experiences.created_at', 'experiences.updated_at'])
                ->join('users', 'experiences.user_id', '=', 'users.id')
                ->join('shops', 'experiences.experiencable_id', '=', 'shops.id')

            )
                ->addColumn('experiencable_title', function($exp) {
                    return  $exp->experiencable->title;
                })
                ->addColumn('operation', function($exp) {
                    return parent::redirectAction('delete/'.$exp->id,'حذف','danger');
                })
                ->rawColumns(['operation'])
                ->make(true);
        }

        $object = 'گزارشات';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' => 'users_fullname', 'name' => 'users.fname', 'title' => 'نام کاربر'])
            ->addColumn(['data' => 'users_fullname', 'name' => 'users.lname', 'title' => 'نام کاربر','class'=>'d-none'])
            ->addColumn(['data' =>'shops_title', 'name' => 'shops.title', 'title' => 'عنوان فروشگاه'])
            ->addColumn(['data' =>'experiencable_id', 'name' => 'experiencable_id', 'title' => 'شماره فروشگاه'])
            ->addColumn(['data' => 'text', 'name' => 'text', 'title' => 'متن'])
            ->addColumn(['data' => 'created_at', 'name' => 'created_at', 'title' => 'ثبت'])
            ->addColumn(['data' => 'updated_at', 'name' => 'updated_at', 'title' => 'ویرایش'])
            ->addColumn(['data' => 'operation', 'name' => 'operation', 'title' => 'عملیات']);
        return view('core::shared.datatable', compact(['html','object']));
    }
    /**
     * Remove the specified resource from storage.
     * @param Request $request
     * @return Response
     */
    public function destroy(Request $request)
    {
        $pid=Experience::find(($request->id))->experiencable_id;
        Experience::find($request->id)->delete();
        return redirect('admin/shop/list/report/'.$pid);

    }
    /**
     * Remove the specified resource from storage.
     * @param Request $request
     * @return Response
     */
    public function delete(Request $request)
    {
        Experience::find($request->id)->delete();
        return response()->json([
            'data'  => true,
            'message'=>'ok',
            'status' => 200
        ]);
    }
    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function store(Request $request)
    {
        $request['user_id']=Auth::user()->id;
        $exp=Shop::where('id',$request->id)->first()->experience()->create($request->all());
        $data=Experience::where('id',$exp->id)->with('user','experiencable')->first();

        return response()->json([
            'data'  => $data,
            'message'=>'ok',
            'status' => 200
        ]);
    }
    /**
     * Update the specified resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function update(Request $request)
    {
        Experience::where('id',$request->id)->update($request->all());
        $data=Experience::where('id',$request->id)->with('user','experiencable')->first();
        return response()->json([
            'data'  => $data,
            'message'=>'ok',
            'status' => 200
        ]);
    }
}
