<?php

namespace Modules\Shop\Entities;

use Elasticquent\ElasticquentTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\Auth;
use Modules\Advertisement\Entities\Advertisement;
use Modules\Advertisement\Entities\Category;
use Modules\Advertisement\Entities\Experience;
use Modules\Blog\Entities\Like;
use Modules\Core\Entities\Attachment;
use Modules\Core\Entities\City;
use Modules\Core\Entities\Document;
use Modules\Core\Entities\User;
use Modules\Shop\Http\Controllers\ShopController;
use NotificationChannels\WebPush\HasPushSubscriptions;

class Shop extends Model
{
    use ElasticquentTrait;
    use SoftDeletes,Notifiable;

    protected $fillable = ['type','price','user_id','title','tell','mobile','address','city_id','latitude','longitude','business_licence','owner','status'];
    protected $appends = ['attachmentsImage','attachmentsVideo','liked','likes','is_owner','categories'];

    function getLikedAttribute(){
        if(!Auth::user())
            return false;
        return $this->like()->where('user_id',Auth::user()->id)->get()->isNotEmpty();
    }
    function getIsOwnerAttribute(){
        if(!Auth::user())
            return false;
        $owner_id=$this->user_id;
        if(isset(Auth::user()->id)) {
            if ($owner_id == Auth::user()->id) {
                return true;
            } else {
                return false;
            }
        }else{
            return false;
        }

    }
    function getLikesAttribute(){
        return $this->like()->count();
    }
    public function getAttachmentsImageAttribute()
    {
        if($this->attachments()){
            return $this->attachments()
                ->whereIn('mime',['png','jpeg','jpg'])
                ->orderBy('id','desc')
                ->get();
        }else{
            return [];
        }
    }
    public function getAttachmentsVideoAttribute()
    {
        if($this->attachments()){
            return $this->attachments()->where('mime','mp4')->orderBy('id','desc')->get();
        }else{
            return [];
        }
    }
    public function getCategoriesAttribute()
    {
        if($this->category()){
            return $this->category()->get();
        }else{
            return [];
        }    }
    public function attachments()
    {
        return $this->morphMany(Attachment::class, 'attachmentable');
    }
    public function advertisement()
    {
        return $this->hasMany(Advertisement::class, 'shop_id');
    }
    public function user()
    {
        return $this->belongsTo(User::class ,'user_id');
    }
    public function city()
    {
        return $this->belongsTo(City::class,'city_id');
    }
    public function requests()
    {
        return $this->hasMany(Shoprequest::class,'shop_id');
    }
    public function category()
    {
        return $this->belongsToMany(Category::class ,'category_shop');
    }
    function like()
    {
        return $this->morphMany(Like::class,'likable');
    }
    public function experience()
    {
        return $this->morphMany(Experience::class, 'experiencable');
    }
    public $adminFields=[
        'user_id'=>[
            'type'=>'select',
            'fa_name'=>'کاربر',
            'col'=>6,
            'required'=>true,
            'data'=>ShopController::class.'@users'
        ],
        'category_id[]'=>[
            'type'=>'multipleSelect',
            'fa_name'=>'دسته بندی',
            'col'=>12,
            'required'=>true,
            'data'=>ShopController::class.'@categories'
        ],
        'title'=>[
            'type'=>'string',
            'fa_name'=>'عنوان',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'type'=>[
            'type'=>'select',
            'fa_name'=>'نوع',
            'col'=>6,
            'required'=>true,
            'data'=>ShopController::class.'@type'
        ],
        'price'=>[
            'type'=>'string',
            'fa_name'=>'قیمت',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'mobile'=>[
            'type'=>'string',
            'fa_name'=>'تلفن همراه',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'tell'=>[
            'type'=>'string',
            'fa_name'=>'تلفن ثابت',
            'col'=>6,
            'required'=>false,
            'data'=>[]
        ],
        'address'=>[
            'type'=>'string',
            'fa_name'=>'آدرس',
            'col'=>6,
            'required'=>false,
            'data'=>[]
        ],
        'status'=>[
            'type'=>'select',
            'fa_name'=>'وضعیت',
            'col'=>6,
            'required'=>false,
            'data'=>ShopController::class.'@status'
        ],
        'owner'=>[
            'type'=>'select',
            'fa_name'=>'وضعیت',
            'col'=>6,
            'required'=>false,
            'data'=>ShopController::class.'@owner'
        ],
        'city_id'=>[
            'type'=>'cities',
            'fa_name'=>'شهر',
            'required'=>true,
            'data'=>[]
        ],
        'map'=>[
            'type'=>'map',
            'fa_name'=>'نقشه',
            'required'=>false,
            'data'=>[]
        ],
    ];
}
