<?php

namespace Modules\QA\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Modules\Core\Http\Controllers\BaseController;
use Modules\QA\Entities\QA;
use Nwidart\Modules\Facades\Module;
use Yajra\DataTables\DataTables;
use Yajra\DataTables\Html\Builder;

class QAController extends BaseController
{
    protected $htmlBuilder;
    public function __construct(Builder $htmlBuilder)
    {
        $this->htmlBuilder = $htmlBuilder;
        $this->htmlBuilder->parameters([
            'paging' => true,
            'searching' => true,
            'info' => false,
            'searchDelay' => 350,
            'language' => [
                'url' => Module::asset('core:datatable.json')
            ],
        ]);
        Parent::__construct();
    }
    public function index(Request $request)
    {
        if ($request->ajax()) {
            return DataTables::of(QA::select(['id','question', 'answer', 'created_at', 'updated_at']))
                ->editColumn('operation', function($q) {
                    return parent::redirectAction('list/delete?id='.$q->id,'حدف','danger mr-1')
                        .parent::redirectAction('list/edit?id='.$q->id,'ویرایش','badge badge-warning mr-1');
                })
                ->rawColumns(['operation'])
                ->make(true);
        }
        $object = 'QA';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' => 'question', 'name' => 'question', 'title' => 'سوال'])
//            ->addColumn(['data' => 'answer', 'name' => 'answer', 'title' => 'جواب'])
            ->addColumn(['data' => 'created_at', 'name' => 'created_at', 'title' => 'ثبت'])
            ->addColumn(['data' => 'updated_at', 'name' => 'updated_at', 'title' => 'ویرایش'])
            ->addColumn(['data' => 'operation', 'name' => 'operation', 'title' => 'عملیات']);
        return view('core::shared.datatable', compact(['html','object']));
    }
    /**
     * Show the specified resource.
     * @return Response
     */
    public function show()
    {
        $data=QA::all();
        return response()->json([
            'data' =>$data,
            'message'=>'ok',
            'status' => 200
        ]);
    }
    /**
     * Remove the specified resource from storage.
     * @param  Request $request
     * @return Response
     */
    public function destroy(Request $request)
    {
        QA::find(($request->id))->delete();
        return redirect('admin/qa/list');
    }
    /**
     * Show the form for creating a new resource.
     * @return Response
     */
    public function add()
    {
        $data['model'] = new QA();
        $data['route_action'] = 'qa.list.store';
        return view('core::shared.add',$data);
    }
    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function store(Request $request)
    {
        QA::create([
            'question' => $request->question,
            'answer' => $request->answer
        ]);
        return redirect()->route('admin.qa.list');
    }
    /**
     * Show the form for editing the specified resource.
     * @param Request $request
     * @return Response
     */
    public function edit(Request $request)
    {
        $data['route_action'] ='qa.list.update';
        $data['data']=QA::find($request->id);
        return view('core::shared.edit', $data);
    }
    /**
     * Update the specified resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function update(Request $request)
    {
        $item= QA::find(($request->id));
        QA::find(($request->id))->update($request->all());
        return redirect()->route('admin.qa.list' );
    }
}
