<?php

namespace Modules\Message\Entities;

use Illuminate\Database\Eloquent\Model;
use Modules\Core\Entities\User;

class Message extends Model
{
    protected $fillable = ['to', 'from', 'text','group_id'];
    public function from_user()
    {
        return $this->belongsTo(User::class ,'from');
    }
    public function to_user()
    {
        return $this->belongsTo(User::class ,'to');
    }
    public function group()
    {
        return $this->belongsTo(Group::class ,'group_id');
    }
}