<?php
Route::group(['middleware' => ['web','auth','acl'], 'prefix' => 'admin','as' => 'admin'], function()
{
    Route::group(['middleware' => 'web', 'prefix' => 'menu', 'namespace' => 'Modules\Menu\Http\Controllers' , 'as'=>'.menu'], function()
    {
        Route::group(['middleware' => 'web', 'prefix' => 'list','as' => '.list' ], function()
        {
            Route::get('/delete','MenuController@destroy');
            Route::get('/','MenuController@index');
            Route::get('/create','MenuController@add')->name('.create');
            Route::post('store', 'MenuController@store')->name('.store');
            Route::get('/edit','MenuController@edit')->name('.edit');
            Route::post('update/{id}', 'MenuController@update')->name('.update');
        });
        Route::group(['middleware' => 'web', 'prefix' => 'item' , 'as'=>'.item'], function()
        {
            Route::get('/edit','ItemController@edit')->name('.edit');
            Route::post('update/{id}', 'ItemController@update')->name('.update');
            Route::get('/delete','ItemController@destroy')->name('.delete');
            Route::get('/{id}/create','ItemController@add')->name('.create');
            Route::post('store/{id}', 'ItemController@store')->name('.store');
            Route::get('/{id}', 'ItemController@index');

            Route::group(['middleware' => 'web', 'prefix' => 'item' , 'as'=>'.item'], function()
            {
                Route::get('/edit','ItemController@editItem')->name('.itemEdit');
                Route::post('/store/{id}', 'ItemController@storeItem')->name('.itemStore');
                Route::post('/update/{id}', 'ItemController@updateItem')->name('.itemUpdate');
                Route::get('/delete','ItemController@destroy')->name('.itemDelete');
                Route::get('/{id}/create','ItemController@addItem')->name('.create');
                Route::get('/{id}', 'ItemController@indexItem');
            });
        });
    });
});

Route::group([ 'prefix' => 'menu', 'namespace' => 'Modules\Menu\Http\Controllers'], function()
{
    Route::get('/show','MenuController@show');
});

