<?php

namespace Modules\Menu\Http\Controllers;

use Faker\Provider\Base;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Modules\Core\Http\Controllers\BaseController;
use Modules\Menu\Entities\Menu;
use Modules\Menu\Http\Requests\CreateMenu;
use Nwidart\Modules\Facades\Module;
use Yajra\DataTables\DataTables;
use Yajra\DataTables\Html\Builder;

class MenuController extends BaseController
{
    protected $htmlBuilder;
    public function __construct(Builder $htmlBuilder)
    {
        $this->htmlBuilder = $htmlBuilder;
        $this->htmlBuilder->parameters([
            'paging' => true,
            'searching' => true,
            'info' => false,
            'searchDelay' => 350,
            'language' => [
                'url' => Module::asset('core:datatable.json')
            ],
        ]);
        Parent::__construct();
    }
    /**
     * Display a listing of the resource.
     * @param Request $request
     * @return Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            return DataTables::of(Menu::select(['id','title','description', 'slug','capacity','created_at','updated_at']))
                ->addColumn('operation', function($menu) {
                    return parent::redirectAction('item/'.$menu->id,'آیتم ها','info mr-1')
                        .parent::redirectAction('list/delete?id='.$menu->id,'حذف','danger mr-1')
                        .parent::redirectAction('list/edit?id='.$menu->id,'ویرایش','warning mr-1');
                })
                ->rawColumns(['operation'])
                ->make(true);
        }
        $object = 'منو ها';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' => 'title', 'name' => 'title', 'title' => 'عنوان'])
            ->addColumn(['data' => 'description', 'name' => 'description', 'title' => 'توضیحات'])
            ->addColumn(['data' => 'slug', 'name' => 'slug', 'title' => 'slug'])
            ->addColumn(['data' => 'capacity', 'name' => 'capacity', 'title' => 'ظرفیت'])
            ->addColumn(['data' => 'created_at', 'name' => 'created_at', 'title' => 'ثبت'])
            ->addColumn(['data' => 'updated_at', 'name' => 'updated_at', 'title' => 'ویرایش'])
            ->addColumn(['data' => 'operation', 'name' => 'operation', 'title' => 'عملیات']);

        return view('core::shared.datatable', compact(['html','object']));
    }
    /**
     * Show the form for creating a new resource.
     * @return Response
     */
    public function add()
    {
        $data['model'] = new Menu();
        $data['route_action'] = 'menu.list.store';
        return view('core::shared.add',$data);
    }
    /**
     * Store a newly created resource in storage.
     * @param  CreateMenu $request
     * @return Response
     */
    public function store(CreateMenu $request)
    {
        $menu = Menu::create($request->all());
        return redirect()->route('admin.menu.list');
    }
    /**
     * Show the specified resource.
     * @return Response
     */
    public function show()
    {
        $data= Menu::all()->groupBy('slug');
        return response()->json([
            'data'  => $data,
            'message'=>'ok',
            'status' => 200
        ]);
    }
    /**
     * Show the form for editing the specified resource.
     * @param Request $request
     * @return Response
     */
    public function edit(Request $request)
    {
        $data['route_action'] ='menu.list.update';
        $data['data']=Menu::find($request->id);
        return view('core::shared.edit', $data);
    }
    /**
     * Update the specified resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function update(Request $request)
    {
        Menu::find(($request->id))->update($request->all());
        return redirect()->route('admin.menu.list' );
    }
    /**
     * Remove the specified resource from storage.
     * @param Request $request
     * @return Response
     */
    public function destroy(Request $request)
    {
        Menu::find($request->id)->delete();
        return redirect('admin/menu/list');
    }
}
