<?php

namespace Modules\Menu\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Modules\Menu\Entities\Item;
use Modules\Menu\Entities\Menu;
use Modules\Core\Http\Controllers\BaseController;
use Nwidart\Modules\Facades\Module;
use Yajra\DataTables\DataTables;
use Yajra\DataTables\Html\Builder;

class ItemController extends BaseController
{
    protected $htmlBuilder;
    public function __construct(Builder $htmlBuilder)
    {
        $this->htmlBuilder = $htmlBuilder;
        $this->htmlBuilder->parameters([
            'paging' => true,
            'searching' => true,
            'info' => false,
            'searchDelay' => 350,
            'language' => [
                'url' => Module::asset('core:datatable.json')
            ],
        ]);
        Parent::__construct();
    }
    /**
     * Display a listing of the resource.
     * @param Request $request
     * @return Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            return DataTables::of(Menu::find($request->id)->subs()->select(['id','title','link','description','slug','display','target_blank','no_follow','image','position','created_at','updated_at']))
                ->addColumn('operation', function($menu) {
                    return parent::redirectAction('item/'.$menu->id,'آیتم ها','info mr-1')
                        .parent::redirectAction('delete?id='.$menu->id,'حذف','danger mr-1')
                        .parent::redirectAction('edit?id='.$menu->id,'ویرایش','warning mr-1');
                })
                ->editColumn('display', function($menu) {

                    if($menu->display==1){
                        return "<span class='btn btn-success'> فعال</span>";
                    }elseif($menu->display==0){
                        return "<span class='btn btn-danger'>غیرفعال</span>";
                    }
                })->editColumn('no_follow', function($menu) {

                    if($menu->no_follow==1){
                        return "<span class='btn btn-success'> فعال</span>";
                    }elseif($menu->no_follow==0){
                        return "<span class='btn btn-danger'>غیرفعال</span>";
                    }
                })->editColumn('target_blank', function($menu) {

                    if($menu->target_blank==1){
                        return "<span class='btn btn-success'> فعال</span>";
                    }elseif($menu->target_blank==0){
                        return "<span class='btn btn-danger'>غیرفعال</span>";
                    }
                })
                ->rawColumns(['operation','display','no_follow','target_blank'])
                ->make(true);
        }
        $object = 'منو ها';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' => 'title', 'name' => 'title', 'title' => 'عنوان'])
            ->addColumn(['data' => 'description', 'name' => 'description', 'title' => 'توضیحات'])
            ->addColumn(['data' => 'slug', 'name' => 'slug', 'title' => 'slug'])
            ->addColumn(['data' => 'link', 'name' => 'link', 'title' => 'لینک'])
            ->addColumn(['data' => 'display', 'name' => 'display', 'title' => 'نمایش'])
            ->addColumn(['data' => 'target_blank', 'name' => 'target_blank', 'title' => 'باز شدن درصفحه جدید'])
            ->addColumn(['data' => 'no_follow', 'name' => 'no_follow', 'title' => 'no follow حالت'])
            ->addColumn(['data' => 'image', 'name' => 'image', 'title' => 'آدرس عکس'])
            ->addColumn(['data' => 'position', 'name' => 'position', 'title' => 'موقعیت'])
            ->addColumn(['data' => 'created_at', 'name' => 'created_at', 'title' => 'ثبت'])
            ->addColumn(['data' => 'updated_at', 'name' => 'updated_at', 'title' => 'ویرایش'])
            ->addColumn(['data' => 'operation', 'name' => 'operation', 'title' => 'عملیات']);
        return view('core::shared.datatable', compact(['html','object']));
    }
    /**
     * Display a listing of Items.
     * @param Request $request
     * @return Response
     */
    public function indexItem(Request $request)
    {
        if ($request->ajax()) {
            return DataTables::of(Item::find($request->id)->subs()->select(['id','title','link','description', 'slug','display','target_blank','no_follow','image','position','created_at','updated_at']))
                ->addColumn('operation', function($menu) {
                    return parent::redirectAction('delete?id='.$menu->id,'حذف','danger mr-1')
                        .parent::redirectAction('edit?id='.$menu->id,'ویرایش','warning mr-1');
                })
                ->editColumn('display', function($blog) {
                    if($blog->display==1){
                        return "<span class='btn btn-success'> فعال</span>";
                    }elseif($blog->display==0){
                        return "<span class='btn btn-danger'>غیرفعال</span>";
                    }
                })
                ->editColumn('no_follow', function($blog) {
                    if($blog->no_follow==1){
                        return "<span class='btn btn-success'> فعال</span>";
                    }elseif($blog->no_follow==0){
                        return "<span class='btn btn-danger'>غیرفعال</span>";
                    }
                })
                ->editColumn('target_blank', function($blog) {

                    if($blog->target_blank==1){
                        return "<span class='btn btn-success'> فعال</span>";
                    }elseif($blog->target_blank==0){
                        return "<span class='btn btn-danger'>غیرفعال</span>";
                    }
                })
                ->rawColumns(['operation','display','no_follow','target_blank'])
                ->make(true);
        }
        $object = 'منو ها';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' => 'title', 'name' => 'title', 'title' => 'عنوان'])
            ->addColumn(['data' => 'description', 'name' => 'description', 'title' => 'توضیحات'])
            ->addColumn(['data' => 'slug', 'name' => 'slug', 'title' => 'slug'])
            ->addColumn(['data' => 'link', 'name' => 'link', 'title' => 'لینک'])
            ->addColumn(['data' => 'display', 'name' => 'display', 'title' => 'نمایش'])
            ->addColumn(['data' => 'target_blank', 'name' => 'target_blank', 'title' => 'باز شدن درصفحه جدید'])
            ->addColumn(['data' => 'no_follow', 'name' => 'no_follow', 'title' => 'no follow حالت'])
            ->addColumn(['data' => 'image', 'name' => 'image', 'title' => 'آدرس عکس'])
            ->addColumn(['data' => 'position', 'name' => 'position', 'title' => 'موقعیت'])
            ->addColumn(['data' => 'created_at', 'name' => 'created_at', 'title' => 'ثبت'])
            ->addColumn(['data' => 'updated_at', 'name' => 'updated_at', 'title' => 'ویرایش'])
            ->addColumn(['data' => 'operation', 'name' => 'operation', 'title' => 'عملیات']);
        return view('core::shared.datatable', compact(['html','object']));
    }
    /**
     * Show the form for creating a new resource.
     * @return Response
     */
    public function add($id)
    {
        $data['model'] = new Item();
        $data['route_action'] = 'menu.item.store';
        $data['params'] = ['id'=>$id];
        $data['id']=$id;
        return view('core::shared.add',$data);

    }
    /**
     * Show the form for creating a new resource.
     * @return Response
     */
    public function addItem($id)
    {
        $data['model'] = new Item();
        $data['route_action'] = 'menu.item.item.itemStore';
        $data['params'] = ['id'=>$id ];
        $data['id']=$id;
        return view('core::shared.add',$data);
    }
    /**
     * Show the form for creating a new resource.
     * @return Response
     */
    public function create()
    {
        $menus = Menu::all();
        return response()->json([
            'data'  => $menus,
            'message'=>'ok',
            'status' => 200
        ]);
    }
    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function store(Request $request)
    {
        $subs = Menu::find($request->id)->subs()->create($request->all());
        return redirect()->route('admin.menu.item' , ['id' => $request->id]);
    }
    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function storeItem(Request $request)
    {
        $subs = Item::find($request->id)->subs()->create($request->all());
        return redirect()->route('admin.menu.item.item' , ['id' => $request->id]);
    }
    /**
     * Show the form for editing the specified resource.
     * @param Request $request
     * @return Response
     */
    public function edit(Request $request)
    {
        $data['route_action'] ='menu.item.update';
        $data['data']=Item::find($request->id);
        return view('core::shared.edit', $data);
    }
    /**
     * Update the specified resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function update(Request $request)
    {
        $item= Item::find(($request->id));
        $parent_id =$item->parent_id;
        Item::find(($request->id))->update($request->all());
        return redirect()->route('admin.menu.item' , ['id' => $parent_id]);
    }
    /**
     * Show the form for editing the specified resource.
     * @param Request $request
     * @return Response
     */
    public function editItem(Request $request)
    {
        $data['route_action'] = 'menu.item.item.itemUpdate';
        $data['data']=Item::find($request->id);
        return view('core::shared.edit', $data);
    }
    /**
     * Update the specified resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function updateItem(Request $request)
    {
        $item= Item::find(($request->id));
        $parent_id =$item->parent_id;
        Item::find(($request->id))->update($request->all());
        return redirect()->route('admin.menu.item.item' , ['id' => $parent_id]);

    }
    /**
     * Remove the specified resource from storage.
     * @param Request $request
     * @return Response
     */
    public function destroy(Request $request)
    {
        $item=Item::find($request->id);
        $parent_id= $item->parent_id;
        $parent_type= $item->parent_type;

        if($parent_type == 'Modules\Menu\Entities\Menu'){
            Item::find($request->id)->delete();
            return redirect('admin/menu/item/'.$parent_id);
        }else{
            Item::find($request->id)->delete();
            return redirect('admin/menu/item/item/'.$parent_id);
        }
    }

    static public function display(){
        return ['1'=>'فعال','0' => 'غیر فعال'];
    }
    static public function target(){
        return ['1'=>'فعال','0' =>'غیر فعال'];
    }
    static public function nofollow(){
        return ['1'=>'فعال','0' => 'غیر فعال'];
    }
    static public function position(){
        return ['1'=>'فعال','0' =>'غیر فعال'];
    }
}
