<?php

namespace Modules\Menu\Entities;

use Elasticquent\ElasticquentTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Menu extends Model
{
    use ElasticquentTrait;
    use SoftDeletes;
    protected $fillable = ['title','description','slug','capacity','link'];
    protected $appends = ['subs'];

    public function getSubsAttribute()
    {
        return $this->subs()->get();
    }
    public function subs()
    {
        return $this->morphMany(Item::class, 'parentable','parent_type','parent_id');
    }
    public $adminFields=[
        'title'=>[
            'type'=>'string',
            'fa_name'=>'عنوان',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'description'=>[
            'type'=>'string',
            'fa_name'=>'توضیحات',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'slug'=>[
            'type'=>'string',
            'fa_name'=>'slug',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'capacity'=>[
            'type'=>'string',
            'fa_name'=>'ظرفیت',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
    ];
}
