<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('items', function (Blueprint $table) {
            $table->increments('id');
            $table->string('title');
            $table->string('description');
            $table->string('slug')->nullable();
            $table->boolean('display')->nullable();
            $table->boolean('target_blank')->nullable();
            $table->boolean('no_follow')->nullable();
            $table->string('image')->nullable();
            $table->string('position')->default(1000);
            $table->unsignedInteger('parent_id');
            $table->string('parent_type');
            $table->string('link')->nullable();

            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('items');
    }
}
