<?php

namespace Modules\Financial\Payments;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Modules\Financial\Contracts\OnlinePayments;
use Modules\Financial\Entities\Gateway;
use Modules\Financial\Entities\Invoice;
use Modules\Financial\Entities\InvoiceTransaction;
use Modules\Financial\Entities\UserCredit;
use Modules\Training\Http\Controllers\CoachController;

class Zarinpal implements OnlinePayments
{

    public function pay($price , InvoiceTransaction $transaction, $request=null)
    {
        $data = array('MerchantID' => '9ac10520-d7e8-11e9-a6d6-000c295eb8fc',
            'Amount' => $price,
            'CallbackURL' => url('/financial/payment_response/zarinpal'),
            'Description' => 'خرید از سایت فابریکا');
        $jsonData = json_encode($data);
        $ch = curl_init('https://www.zarinpal.com/pg/rest/WebGate/PaymentRequest.json');
        curl_setopt($ch, CURLOPT_USERAGENT, 'ZarinPal Rest Api v1');
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Content-Length: ' . strlen($jsonData)
        ));
        $result = curl_exec($ch);
        $err = curl_error($ch);
        $result = json_decode($result, true);
        curl_close($ch);
        if ($err) {
            echo "cURL Error #:" . $err;
        }else {
            if ($result["Status"] == 100) {
                $transaction->update(['transaction_reference_id'=>$result['Authority']]);
                header('Location: https://www.zarinpal.com/pg/StartPay/' . $result["Authority"]);
            }else{
                echo 'ERR: ' . $result["Status"];
            }
        }
    }
    /**
     * @param Request $request
     * @return array
     */
    public function response(Request $request){
        $Authority = $request->Authority;
        $transaction = InvoiceTransaction::where('transaction_reference_id',$Authority)->first();
        $data = array('MerchantID' => '9ac10520-d7e8-11e9-a6d6-000c295eb8fc', 'Authority' => $Authority, 'Amount' => $transaction->invoice->amount);
        $jsonData = json_encode($data);
        $ch = curl_init('https://www.zarinpal.com/pg/rest/WebGate/PaymentVerification.json');
        curl_setopt($ch, CURLOPT_USERAGENT, 'ZarinPal Rest Api v1');
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Content-Length: ' . strlen($jsonData)
        ));
        $result = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);
        $result = json_decode($result, true);
        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            if ($result['Status'] == 100) {
               $transaction->update(['status'=>1]);
               return ['status'=>true,'transaction'=>$transaction];
            }
            else {
                return ['status'=>false,'transaction'=>$transaction];
            }
        }
    }
}
