<?php

namespace Modules\Financial\Payments;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Modules\Financial\Contracts\OnlinePayments;
use Modules\Financial\Entities\Cart;
use Modules\Financial\Entities\Gateway;
use Modules\Financial\Entities\Invoice;
use Modules\Financial\Entities\InvoiceTransaction;
use Modules\Financial\Entities\UserCredit;
use Modules\Training\Http\Controllers\CoachController;

class Carts implements OnlinePayments
{
    public function pay($price , InvoiceTransaction $transaction ,$request=null)
    {
        $trace = $request->trace;
        Cart::create([
            'invoice_id' => $transaction->invoice->id,
            'trace' => $trace,
        ]);
        Invoice::find($transaction->invoice->id)->update(['paid' => 2]);
        if($request->ajax()){
            return response()->json([
                'data'  => true,
                'message'=>'ok',
                'status' => 200
            ]);
        }
        return header('Location: '.url('/panel/wallet'));

    }
    /**
     * @param Request $request
     * @return array
     */
    public function response(Request $request){
        return ['status'=>true,'transaction'=>$request->transaction];
    }
}
