<?php

namespace Modules\Financial\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Modules\Financial\Contracts\OnlinePayments;
use Modules\Financial\Entities\Discount;
use Modules\Financial\Entities\Gateway;
use Modules\Financial\Entities\Invoice;
use Modules\Financial\Entities\InvoiceTransaction;
use Modules\Financial\Entities\UserCredit;
use Modules\Financial\Payments\Carts;
use Modules\Financial\Payments\Wallet;
use Modules\Financial\Payments\Zarinpal;
use Modules\Training\Http\Controllers\CoachController;

class PaymentController extends Controller
{
    protected $gateway;
    protected $amount;
    protected $transaction;
    public function pay(Request $request){
        $invoice = Invoice::find($request->invoice);
        $gateway = Gateway::find($request->gateway);
        switch ($gateway->slug){
            case 'zarinpal':
                $this->gateway = new Zarinpal();
                break;
            case 'wallet':
                $this->gateway = new Wallet();
                break;
            case 'carts':
                $this->gateway = new Carts();
                break;
        }
        $this->transaction = InvoiceTransaction::create([
            'invoice_id'=>$invoice->id,
            'gateway_id'=>$gateway->id,
            'card_number'=>'',
            'transaction_reference_id'=>'',
            'trace_number'=>'',
            'reference_number'=>'',
            'extra_data'=>'',
            'status'=>0
        ]);
        $this->amount = $invoice->amount;
        $this->request = $request;

//        if(isset($request->trace)){
//            $trace = $request->trace;
//            $this->trace = $trace;
//        }else{
//            $this->trace ='';
//        }

        self::pay_handler();
    }

    protected function pay_handler(){
        $data = $this->gateway->pay($this->amount , $this->transaction , $this->request);
        if(is_string($data)){
            return response()->json([
                'data'=>$data,
                'status'=>200,
                'message'=>'something went true'
            ]);
        }else{
            return $data;
        }
    }

    public function response($gateway,Request $request){
        switch ($gateway){
            case 'zarinpal':
                $this->gateway = new Zarinpal();
                break;
            case 'wallet':
                $this->gateway = new Wallet();
                break;
            case 'carts':
                $this->gateway = new Carts();
                break;
        }
        return self::response_handler($request);
    }

    protected function response_handler($request){
        $response = $this->gateway->response($request);
        if($response['status']){
            $invoice = Invoice::find($response['transaction']->invoice_id);
//b
            if($invoice->off_code !=null){
                $use=Discount::where('code',$invoice->off_code)->first()->use;
                if($use > 0)
                    Discount::where('code',$invoice->off_code)->update(['use'=>$use-1]);
            }
            //
            $invoice->update(['paid'=>1]);

            $class= explode('@',$invoice->handler)[0];
            $func= explode('@',$invoice->handler)[1];
            $class::$func($invoice->data);
            //todo:fix redirect
            return redirect('/finished?status=success&transaction='.$response['transaction']->id);
        }else{
            //todo:fix redirect
            return redirect('/finished?status=failed&transaction='.$response['transaction']->id);
        }
    }
}