<?php

namespace Modules\Financial\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Modules\Core\Http\Controllers\BaseController;
use Modules\Financial\Entities\Package;
use Yajra\DataTables\Html\Builder;
use Nwidart\Modules\Facades\Module;
use Yajra\DataTables\DataTables;

class PackageController extends BaseController
{
    protected $htmlBuilder;
    public function __construct(Builder $htmlBuilder)
    {
        $this->htmlBuilder = $htmlBuilder;
        $this->htmlBuilder->parameters([
            'paging' => true,
            'searching' => true,
            'info' => false,
            'searchDelay' => 350,
            'language' => [
                'url' => Module::asset('core:datatable.json')
            ],
        ]);
        Parent::__construct();
    }
    public function index(Request $request)
    {
        if ($request->ajax()) {
            return DataTables::of(Package::select(['id','title','fa','amount','handler', 'created_at', 'updated_at']))
                ->addColumn('operation', function($package) {
                    return parent::redirectAction('packages/delete/'.$package->id,'حذف','danger')
                        . parent::redirectAction('packages/edit/'.$package->id,'ویرایش','warning');
                })
                ->rawColumns(['operation','status'])
                ->make(true);
        }
        $object = 'پکیج ها';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' =>'title', 'name' => 'title', 'title' => 'عنوان'])
            ->addColumn(['data' => 'fa', 'name' => 'fa', 'title' => 'پکیج'])
            ->addColumn(['data' => 'amount', 'name' => 'amount', 'title' => 'قیمت'])
            ->addColumn(['data' => 'handler', 'name' => 'handler', 'title' => 'handler'])
            ->addColumn(['data' => 'created_at', 'name' => 'created_at', 'title' => 'ثبت'])
            ->addColumn(['data' => 'updated_at', 'name' => 'updated_at', 'title' => 'ویرایش'])
            ->addColumn(['data' => 'operation', 'name' => 'operation', 'title' => 'عملیات']);
        return view('core::shared.datatable', compact(['html','object']));
    }
    /**
     * Remove the specified resource from storage.
     * @param Request $request
     * @return Response
     */
    public function destroy(Request $request)
    {
        Package::find($request->id)->delete();
        return redirect('admin/financial/packages');
    }
    /**
     * show resource in storage.
     * @return Response
     */
    public function show()
    {
        $data=Package::all();
        return response()->json([
            'data'  => $data,
            'message'=>'ok',
            'status' => 200
        ]);
    }
    /**
     * Show the form for editing the specified resource.
     * @param Request $request
     * @return Response
     */
    public function edit(Request $request)
    {
        $data['route_action'] = 'financial.packages.update';
        $data['data']=Package::find($request->id);
        return view('core::shared.edit', $data);
    }
    /**
     * Update the specified resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function update(Request $request)
    {
        Package::where('id',$request->id)->update([
            'fa'=>$request->fa,
            'amount'=>$request->amount,
            'handler'=>$request->handler,
        ]);
        return redirect()->route('admin.financial.packages');
    }
}
