<?php

namespace Modules\Financial\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Modules\Core\Http\Controllers\BaseController;
use Modules\Financial\Entities\cart;
use Modules\Financial\Entities\Discount;
use Modules\Financial\Entities\Invoice;
use Modules\Training\Entities\Move;
use Nwidart\Modules\Facades\Module;
use phpDocumentor\Reflection\Types\Parent_;
use Yajra\DataTables\Html\Builder;
use Yajra\DataTables\DataTables;

class InvoicesController extends BaseController
{
    /**
     * Datatables Html Builder
     * @var Builder
     */
    protected $htmlBuilder;
    public function __construct(Builder $htmlBuilder)
    {
        $this->htmlBuilder = $htmlBuilder;
        $this->htmlBuilder->parameters([
            'paging' => true,
            'searching' => true,
            'info' => false,
            'searchDelay' => 350,
            'language' => [
                'url' => Module::asset('core:datatable.json')
            ],
        ]);
        Parent::__construct();
    }
    /**
     * Display a listing of the resource.
     * @param Request $request
     * @throws
     * @return Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            return DataTables::of(Invoice::select(['id','user_id', 'amount','content', 'paid','description','created_at']))
                ->addColumn('action',function($model){
//                    return parent::deleteAction($model->id).
                    return parent::redirectAction(route('admin.financial.invoices.paid',$model->id),'پرداخت','primary')
                        .parent::redirectAction('invoices/edit?id='.$model->id,'ویرایش','warning mr-1');
                })
                ->addColumn('trace',function($model){
                    $check=cart::where('invoice_id',$model->id)->first();
                    if($check == null){
                        return '';
                    }else{
                        return $check->trace ;
                    }
                })
                ->editColumn('user_id',function($model){
                    return $model->user->fname.' '.$model->user->lname;
                })
//                ->editColumn('paid',function($model){
//                    return '<span class="badge badge-'.($model->paid?'success':'danger').'">'.($model->paid?'پرداخت شده':'در انتظار پرداخت').'</span>';
//                })
                ->editColumn('paid', function($model) {
                    if($model->paid==1){
                        return "<span class='btn btn-success'> پرداخت شده</span>";
                    }elseif($model->paid==2){
                        return "<span class='btn btn-warning'>کارت به کارت</span>";
                    }else{
                        return "<span class='btn btn-danger'>در انتظار پرداخت</span>";
                    }
                })
                ->rawColumns(['action','paid','trace'])
                ->make(true);
        }
        $object = 'فاکتور ها';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' => 'user_id', 'name' => 'user_id', 'title' => 'نام کاربر'])
            ->addColumn(['data' => 'amount', 'name' => 'amount', 'title' => 'مبلغ(ر)'])
            ->addColumn(['data' => 'description', 'name' => 'description', 'title' => 'بابت'])
            ->addColumn(['data' => 'paid', 'name' => 'paid', 'title' => 'وضعیت'])
            ->addColumn(['data' => 'content', 'name' => 'content', 'title' => 'توضیحات'])
            ->addColumn(['data' => 'created_at', 'name' => 'created_at', 'title' => 'ثبت'])
            ->addColumn(['data' => 'action', 'name' => 'action', 'title' => 'عملیات']);
        return view('core::shared.datatable', compact(['html','object']));
    }
    /**
     * Show the form for editing the specified resource.
     * @param Request $request
     * @return Response
     */
    public function edit(Request $request)
    {

        $data['route_action'] = 'financial.invoices.update';
        $data['data']=Invoice::find($request->id);
        return view('core::shared.edit', $data);
    }
    /**
     * Update the specified resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function update(Request $request)
    {
        Invoice::find(($request->id))->update($request->all());

        return redirect()->route('admin.financial.invoices');
    }
    /**
     * Show the specified resource.
     * @return Response
     */
    public function show()
    {
        return view('training::show');
    }

    public function setPaid(Request $request){
        $invoice = Invoice::find($request->id);

        if($invoice->off_code !=null){
            $use=Discount::where('code',$invoice->off_code)->first()->use;
            if($use > 0)
            Discount::where('code',$invoice->off_code)->update(['use'=>$use-1]);
        }
        $invoice->update(['paid'=>1]);

        $class= explode('@',$invoice->handler)[0];
        $func= explode('@',$invoice->handler)[1];
        $class::$func($invoice->data);
        return back();
    }

    public function pay(Request $request){
        $invoice = Invoice::find($request->id);

        if($invoice->off_code !=null){
            $use=Discount::where('code',$invoice->off_code)->first()->use;
            if($use > 0)
                Discount::where('code',$invoice->off_code)->update(['use'=>$use-1]);
        }
        $invoice->update(['paid'=>1]);

        $class= explode('@',$invoice->handler)[0];
        $func= explode('@',$invoice->handler)[1];
        $class::$func($invoice->data);
        return response()->json([
            'data'  => true,
            'message'=>'ok',
            'status' => 200
        ]);    }

    public function destroy(Request $request)
    {
        Invoice::find($request->id)->delete();
        return 'OK';
    }
}
