<?php

namespace Modules\Financial\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Modules\Core\Http\Controllers\BaseController;
use Modules\Financial\Entities\Invoice;
use Modules\Financial\Entities\InvoiceTransaction;
use Modules\Training\Entities\Move;
use Nwidart\Modules\Facades\Module;
use phpDocumentor\Reflection\Types\Parent_;
use Yajra\DataTables\Html\Builder;
use Yajra\DataTables\DataTables;

class InvoiceTransactionsController extends BaseController
{
    /**
     * Datatables Html Builder
     * @var Builder
     */
    protected $htmlBuilder;

    public function __construct(Builder $htmlBuilder)
    {
        $this->htmlBuilder = $htmlBuilder;
        $this->htmlBuilder->parameters([
            'paging' => true,
            'searching' => true,
            'info' => false,
            'searchDelay' => 350,
            'language' => [
                'url' => Module::asset('core:datatable.json')
            ],
        ]);
        Parent::__construct();
    }


    /**
     * Display a listing of the resource.
     * @param Request $request
     * @throws
     * @return Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            return DataTables::of(InvoiceTransaction::select(['id', 'invoice_id', 'card_number', 'transaction_reference_id', 'trace_number', 'reference_number', 'extra_data', 'status']))
                ->addColumn('action',function($model){
                    return parent::deleteAction($model->id);
                })
                ->editColumn('status',function($model){
                    return '<span class="badge badge-'.($model->status?'success':'danger').'">'.($model->status?'پرداخت شده':'خطا در عملیات پرداخت').'</span>';
                })
                ->rawColumns(['action','status'])
                ->make(true);
        }
        $object = 'تراکنش ها';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>
                'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' => 'invoice_id', 'name' => 'user_id', 'title' => 'شماره فاکتور'])
            ->addColumn(['data' => 'card_number', 'name' => 'amount', 'title' => 'شماره کارت'])
            ->addColumn(['data' => 'transaction_reference_id', 'name' => 'paid', 'title' => 'شماره تراکنش'])
            ->addColumn(['data' => 'trace_number', 'name' => 'created_at', 'title' => 'کد رهگیری'])
            ->addColumn(['data' => 'reference_number', 'name' => 'created_at', 'title' => 'کد ارجاع'])
            ->addColumn(['data' => 'extra_data', 'name' => 'created_at', 'title' => 'اطلاعات اضافی'])
            ->addColumn(['data' => 'status', 'name' => 'created_at', 'title' => 'وضعیت'])
            ->addColumn(['data' => 'action', 'name' => 'action', 'title' => 'عملیات']);

        return view('core::shared.datatable', compact(['html','object']));
    }

    /**
     * Remove the specified resource from storage.
     * @return Response
     */
    public function destroy(Request $request)
    {
        Invoice::find($request->id)->delete();
        return 'OK';

    }
}
