<?php

namespace Modules\Financial\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Modules\Core\Http\Controllers\BaseController;
use Modules\Financial\Entities\Gateway;
use Modules\Financial\Entities\Invoice;
use Modules\Financial\Entities\InvoiceTransaction;
use Modules\Training\Entities\Move;
use Nwidart\Modules\Facades\Module;
use phpDocumentor\Reflection\Types\Parent_;
use Yajra\DataTables\Html\Builder;
use Yajra\DataTables\DataTables;

class GatewaysController extends BaseController
{
    /**
     * Datatables Html Builder
     * @var Builder
     */
    protected $htmlBuilder;

    public function __construct(Builder $htmlBuilder)
    {
        $this->htmlBuilder = $htmlBuilder;
        $this->htmlBuilder->parameters([
            'paging' => true,
            'searching' => true,
            'info' => false,
            'searchDelay' => 350,
            'language' => [
                'url' => Module::asset('core:datatable.json')
            ],
        ]);
        Parent::__construct();
    }


    /**
     * Display a listing of the resource.
     * @param Request $request
     * @throws
     * @return Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            return DataTables::of(Gateway::select(['id', 'title', 'description', 'active']))
                ->addColumn('action',function($model){
                    return  parent::redirectAction(route('admin.financial.gateways.edit',$model->id),'ویرایش','primary');
                })
                ->editColumn('active',function($model){
                    return '<span class="badge badge-'.($model->active?'success':'danger').'">'.($model->active?'فعال':'غیرفعال').'</span>';
                })
                ->rawColumns(['action','active'])
                ->make(true);
        }
        $object = 'درگاه ها';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>
                'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' => 'title', 'name' => 'user_id', 'title' => 'نام درگاه'])
            ->addColumn(['data' => 'description', 'name' => 'amount', 'title' => 'توضیحات درگاه'])
            ->addColumn(['data' => 'active', 'name' => 'paid', 'title' => 'وضعیت'])
            ->addColumn(['data' => 'action', 'name' => 'action', 'title' => 'عملیات']);

        return view('core::shared.datatable', compact(['html','object']));
    }

    /**
     * Show the form for editing the specified resource.
     * @return Response
     */
    public function edit(Request $request)
    {
        $data['data'] = Gateway::find($request->id);
        $data['route_action'] = 'financial.gateways.update';
        return view('core::shared.edit',$data);
    }

    /**
     * Update the specified resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function update(Request $request)
    {
        Gateway::find($request->id)->update($request->all());
        return redirect(route('admin.financial.gateways'));
    }

}
