<?php

namespace Modules\Financial\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Modules\Core\Entities\User;
use Modules\Financial\Entities\Discount;
use Modules\Training\Entities\Coach;
use Modules\Core\Http\Controllers\BaseController;

use Yajra\DataTables\DataTables;
use Yajra\DataTables\Html\Builder;
use Nwidart\Modules\Facades\Module;

class DiscountController extends BaseController
{
    protected $htmlBuilder;
    public function __construct(Builder $htmlBuilder)
{
    $this->htmlBuilder = $htmlBuilder;
    $this->htmlBuilder->parameters([
        'paging' => true,
        'searching' => true,
        'info' => false,
        'searchDelay' => 350,
        'language' => [
            'url' => Module::asset('core:datatable.json')
        ],
    ]);
    Parent::__construct();
}
    /*
     * Display a listing of the resource.
     * @param Request $request
     * @return Response
     */
    public function index(Request $request)
{
    if ($request->ajax()){
        return DataTables::of(Discount::select(['id','code','action','use','expiration_time','created_at','updated_at']))
            ->addColumn('operation', function($code){
                $href='discounts/edit/'.$code->id;
                return  parent::redirectAction($href,'ویرایش','warning mr-1')
                    .parent::redirectAction('discounts/delete?id='.$code->id,'حذف','danger mr-1');
            })
            ->rawColumns(['operation'])
            ->make(true);
    }
    $object = 'کد تخفیف';
    $html = $this->htmlBuilder
        ->addColumn(['data' =>'id', 'name' => 'id', 'title' => 'شناسه'])
        ->addColumn(['data' =>'code', 'name' => 'code', 'title' => 'کد'])
        ->addColumn(['data' =>'use', 'name' => 'use', 'title' => 'تعداد استفاده'])
        ->addColumn(['data' =>'action', 'name' => 'action', 'title' => 'درصد تفیف'])
        ->addColumn(['data' =>'expiration_time', 'name' => 'expiration_time', 'title' => 'زمان انقضا'])
        ->addColumn(['data' => 'created_at', 'name' => 'created_at', 'title' => 'ثبت'])
        ->addColumn(['data' => 'updated_at', 'name' => 'updated_at', 'title' => 'ویرایش'])
        ->addColumn(['data' => 'operation', 'name' => 'operation', 'title' => 'عملیات']);

    return view('core::shared.datatable', compact(['html','object']));
}
    /**
     * Show the form for creating a new resource.
     * @return array
     */
    public function create(){
    $data['model'] = new Discount();
    $data['route_action'] = 'financial.discounts.store';
    return view('core::shared.add',$data);
}
    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function store(Request $request){
    $discount = Discount::create($request->all());
    return redirect()->route('admin.financial.discounts');
}
    /**
     * Show the form for editing the specified resource.
     * @param Request $request
     * @return Response
     */
    public function edit(Request $request){
    $data['route_action'] = 'financial.discounts.update';
    $data['data']=Discount::find($request->id);
    return view('core::shared.edit', $data);
}
    /**
     * Update the specified resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function update(Request $request){
    $id=$request->id;
    Discount::find($id)->update($request->all());
    return redirect()->route('admin.financial.discounts');
}
    /**
     * Remove the specified resource from storage.
     * @param Request $request
     * @return Response
     */
    public function destroy(Request $request){
    Discount::find($request->id)->delete();
    return redirect('admin/financial/discounts');
}
}
