<?php

namespace Modules\Financial\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Core\Entities\User;
use Modules\Core\Http\Controllers\BaseController;
use Modules\Financial\Entities\Gateway;
use Modules\Financial\Entities\Invoice;
use Modules\Financial\Entities\InvoiceTransaction;
use Modules\Financial\Entities\UserCredit;
use Modules\Training\Entities\Move;
use Nwidart\Modules\Facades\Module;
use phpDocumentor\Reflection\Types\Parent_;
use Yajra\DataTables\Html\Builder;
use Yajra\DataTables\DataTables;

class CreditsController extends BaseController
{
    /**
     * Datatables Html Builder
     * @var Builder
     */
    protected $htmlBuilder;

    public function __construct(Builder $htmlBuilder)
    {
        $this->htmlBuilder = $htmlBuilder;
        $this->htmlBuilder->parameters([
            'paging' => true,
            'searching' => true,
            'info' => false,
            'searchDelay' => 350,
            'language' => [
            'url' => Module::asset('core:datatable.json')
            ],
        ]);
        Parent::__construct();
    }
    /**
     * Display a listing of the resource.
     * @param Request $request
     * @throws
     * @return Response
     */
    public function index(Request $request)
    {$check=UserCredit::get();
       if($check->isEmpty()){
           if ($request->ajax()) {
               return DataTables::of(UserCredit::select(['id']))
                   ->rawColumns(['action','active'])
                   ->make(true);
           }
           $object = 'کیف پول';
           $html = $this->htmlBuilder
               ->addColumn(['data' => 'id', 'name' => 'id', 'title' => 'شناسه'])
               ->addColumn(['data' => 'amount', 'name' => 'user_id', 'title' => 'موجودی'])
               ->addColumn(['data' => 'user_id', 'name' => 'amount', 'title' => 'نام کاربر']);
           return view('core::shared.datatable', compact(['html','object']));
       }else{
           if ($request->ajax()) {
               return DataTables::of(UserCredit::select(DB::raw('sum(amount) as amount'),'id','user_id'))
                   ->addColumn('action',function($model){
                       return  ;
                   })
                   ->editColumn('user_id',function($model){
                       $user = User::find($model->user_id);
                       return $user->fname.' '.$user->lname;
                   })
                   ->rawColumns(['action','active'])
                   ->make(true);
           }
           $object = 'کیف پول';
           $html = $this->htmlBuilder
               ->addColumn(['data' =>
                   'id', 'name' => 'id', 'title' => 'شناسه'])
               ->addColumn(['data' => 'amount', 'name' => 'user_id', 'title' => 'موجودی'])
               ->addColumn(['data' => 'user_id', 'name' => 'amount', 'title' => 'نام کاربر']);
           return view('core::shared.datatable', compact(['html','object']));       }

    }

    /**
     * Show the form for editing the specified resource.
     * @param Request $request
     * @return Response
     */
    public function edit(Request $request)
    {
        $data['data'] = Gateway::find($request->id);
        $data['route_action'] = 'financial.gateways.update';
        return view('core::shared.edit',$data);
    }
    /**
     * Update the specified resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function update(Request $request)
    {
        Gateway::find($request->id)->update($request->all());
        return redirect(route('admin.financial.gateways'));
    }

    static function chargeWallet($data){
        $data = json_decode($data,1);
        UserCredit::charge($data['user_id'],$data['amount']);
        return true;
    }
}
