<?php

namespace Modules\Financial\Entities;

use Illuminate\Database\Eloquent\Model;
use Modules\Core\Entities\User;

class Gateway extends Model
{
    protected $fillable = ['title','description','type','active','slug','username','password','extra_credential'];

    public $adminFields=[

        'title'=>[
            'type'=>'string',
            'fa_name'=>'عنوان',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'description'=>[
            'type'=>'string',
            'fa_name'=>'توضیحات',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'username'=>[
            'type'=>'string',
            'fa_name'=>'نام کاربری',
            'col'=>4,
            'required'=>true,
            'data'=>[]
        ],
        'password'=>[
            'type'=>'string',
            'fa_name'=>'پسوورد',
            'col'=>4,
            'required'=>true,
            'data'=>[]
        ],
        'extra_credential'=>[
            'type'=>'string',
            'fa_name'=>'اطلاعات اضافه',
            'col'=>4,
            'required'=>true,
            'data'=>[]
        ],
        'active'=>[
            'type'=>'boolean',
            'fa_name'=>'وضعیت',
            'col'=>2,
            'required'=>false,
            'data'=>[]
        ]

    ];

}
