<?php

namespace Modules\Financial\Entities;

use Illuminate\Database\Eloquent\Model;

class Discount extends Model
{
    protected $fillable = ['code','use','action','expiration_time','created_at','updated_at'];
    public $adminFields=[
        'code'=>[
            'type'=>'string',
            'fa_name'=>'کد',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'action'=>[
            'type'=>'string',
            'fa_name'=>'درصد تفیف',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'use'=>[
            'type'=>'string',
            'fa_name'=>'تعداد استفاده',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'expiration_time'=>[
            'type'=>'dateTime',
            'fa_name'=>'زمان انقضا',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
    ];
}
