<?php

Route::group(['middleware' => ['web','auth','acl'], 'prefix' => 'admin','as' => 'admin'], function()
{
    Route::group(['middleware' => 'web', 'prefix' => 'expert', 'namespace' => 'Modules\Expert\Http\Controllers' , 'as'=>'.expert'], function()
    {
        Route::group(['middleware' => 'web', 'prefix' => 'list','as' => '.list' ], function()
        {
            Route::get('/', 'ExpertController@index');
            Route::get('/delete','ExpertController@destroy')->name('.delete');
            Route::get('/create','ExpertController@add')->name('.create');
            Route::post('store', 'ExpertController@store')->name('.store');
            Route::get('/edit','ExpertController@edit')->name('.edit');
            Route::post('update/{id}', 'ExpertController@update')->name('.update');
        });
    });
    Route::group(['middleware' => 'web', 'prefix' => 'protest', 'namespace' => 'Modules\Expert\Http\Controllers' , 'as'=>'.protest'], function()
    {
        Route::group(['middleware' => 'web', 'prefix' => 'list','as' => '.list' ], function()
        {
            Route::get('/', 'ProtestController@index');
            Route::get('/delete','ProtestController@destroy')->name('.delete');
        });
    });

    Route::group(['middleware' => 'web', 'prefix' => 'user_expert', 'namespace' => 'Modules\Expert\Http\Controllers' , 'as'=>'.protest'], function()
    {
        Route::group(['middleware' => 'web', 'prefix' => 'list','as' => '.list' ], function()
        {
            Route::get('/', 'UserexpertController@index');
        });
    });
});
//front-end routes
Route::group([ 'prefix' => 'expert', 'namespace' => 'Modules\Expert\Http\Controllers','middleware' => 'web'], function()
{
    Route::post('/show','ExpertController@show')->name('.show');
    Route::get('/single','ExpertController@single')->name('.single');
    Route::get('/show-all', 'ExpertController@showAll')->name('.showAll');
});

Route::middleware(['auth:api'])->group(function () {

    Route::group([ 'prefix' => 'expert', 'namespace' => 'Modules\Expert\Http\Controllers'], function(){
        Route::post('/list-experts','ExpertController@listExperts');
        Route::post('/assign','ExpertController@assign');
        Route::get('/wait-list','ExpertController@waitList');
        Route::get('/accepted-list','ExpertController@acceptedList');
        Route::post('/edit-list','ExpertController@editList');
        Route::post('/update','ExpertController@updateCat');
        Route::post('/create','ExpertController@create');
        Route::post('/point','ExpertController@point');
        Route::post('/get-point','ExpertController@getPoint');
        Route::get('/list','UserexpertController@list');
        Route::group([ 'prefix' => 'comment'], function(){

            Route::post('/','UserexpertController@comment');
            Route::post('/delete','UserexpertController@deleteComment');
            Route::get('/expert','UserexpertController@expertComment');
        });
    });

    Route::group([ 'prefix' => 'protest', 'namespace' => 'Modules\Expert\Http\Controllers'], function(){
        Route::post('/delete','ProtestController@delete');
        Route::post('/store','ProtestController@store');
        Route::post('/update','ProtestController@update');
        Route::get('/show','ProtestController@showAll');
    });

});



