<?php

namespace Modules\Expert\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Modules\Blog\Entities\Comment;
use Modules\Expert\Entities\UserExpert;
use Yajra\DataTables\DataTables;
use Yajra\DataTables\Html\Builder;
use Nwidart\Modules\Facades\Module;
use Modules\Core\Http\Controllers\BaseController;

class UserexpertController  extends  BaseController
{
    protected $htmlBuilder;
    public function __construct(Builder $htmlBuilder)
    {
        $this->htmlBuilder = $htmlBuilder;
        $this->htmlBuilder->parameters([
            'paging' => true,
            'searching' => true,
            'info' => false,
            'searchDelay' => 350,
            'language' => [
                'url' => Module::asset('core:datatable.json')
            ],
        ]);
        Parent::__construct();
    }
    public function index(Request $request)
    {
        if ($request->ajax()) {
            return DataTables::of(UserExpert::select(['user_expert.id',
                DB::raw('concat(users.fname ," ",users.lname) as users_fullname ')
                ,'expert_id','adv_id','user_expert.status','user_expert.description','user_expert.content','user_expert.time','user_expert.point','user_expert.created_at','user_expert.updated_at'])
                ->join('users', 'user_expert.user_id', '=', 'users.id'))
                ->editColumn('expert_id', function($UserExpert) {
                    return $UserExpert->expert->user->fname . ' ' . $UserExpert->expert->user->lname;
                })
                ->editColumn('status', function($adv) {
                    if($adv->status==1){
                        return "<span class='btn btn-success'>قبول شده</span>";
                    }elseif($adv->status==0){
                        return "<span class='btn btn-danger'>رد شده</span>";
                    }
                })
                ->rawColumns(['status'])
                ->make(true);
        }
        $object = 'کارشناسان-کاربران';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' => 'users_fullname', 'name' => 'users.fname', 'title' => 'نام کاربر'])
            ->addColumn(['data' => 'users_fullname', 'name' => 'users.lname', 'title' => 'نام کاربر','class'=>'d-none'])
            ->addColumn(['data' => 'expert_id', 'name' => 'expert_id', 'title' => 'کارشناس'])
            ->addColumn(['data' => 'status', 'name' => 'status', 'title' => 'وضغیت'])
            ->addColumn(['data' => 'description', 'name' => 'description', 'title' => 'توضیحات'])
            ->addColumn(['data' => 'content', 'name' => 'content', 'title' => 'متن'])
            ->addColumn(['data' => 'time', 'name' => 'time', 'title' => 'زمان'])
            ->addColumn(['data' => 'point', 'name' => 'point', 'title' => 'امتیاز'])
            ->addColumn(['data' => 'created_at', 'name' => 'created_at', 'title' => 'ثبت'])
            ->addColumn(['data' => 'updated_at', 'name' => 'updated_at', 'title' => 'ویرایش']);
        return view('core::shared.datatable', compact(['html','object']));
    }
    function comment(Request $request){
        $expert=UserExpert::find($request->id);
        $comment=$expert->comments()->create([
            'comment'=>$request->comment,
            'user_id'=>Auth::user()->id,
        ]);

        $results=Comment::where('id',$comment->id)->with('commentable')->first();
        return response()->json([
            'data'  => $results,
            'message'=>__('ok'),
            'status' => 200
        ]);
    }
    public function deleteComment(Request $request)
    {
        $user_id=Comment::where('id',$this->id)->first()->user_id;
        if($user_id == Auth::user()->id){
            Comment::find($request->id)->delete();
            return response()->json([
                'data' =>true,
                'message'=>'deleted',
                'status' => 200
            ]);
        }else{
            return response()->json([
                'data' =>false,
                'message'=>'cant delete',
                'status' => 400
            ]);
        }

    }
    public function list(){
        $data=UserExpert::where('user_id',Auth::user()->id)->get();
        return response()->json([
            'data'  => $data,
            'message'=>'ok',
            'status' => 200
        ]);
    }
    public function expertComment(Request $request){
        $ids=UserExpert::where('expert_id',$request->id)->pluck('id');
        $data=Comment::whereIn('commentable_id',$ids)
            ->where('commentable_type','Modules\Expert\Entities\UserExpert')
            ->orderBy('id','desc')
            ->get();

        return response()->json([
            'data'  => $data,
            'message'=>__('ok'),
            'status' => 200
        ]);
    }
}
