<?php

namespace Modules\Expert\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Modules\Core\Entities\User;
use Modules\Expert\Entities\Expert;
use Modules\Expert\Entities\Protest;
use Yajra\DataTables\DataTables;
use Yajra\DataTables\Html\Builder;
use Nwidart\Modules\Facades\Module;
use Modules\Core\Http\Controllers\BaseController;

class ProtestController extends BaseController
{
    protected $htmlBuilder;
    public function __construct(Builder $htmlBuilder)
    {
        $this->htmlBuilder = $htmlBuilder;
        $this->htmlBuilder->parameters([
            'paging' => true,
            'searching' => true,
            'info' => false,
            'searchDelay' => 350,
            'language' => [
                'url' => Module::asset('core:datatable.json')
            ],
        ]);
        Parent::__construct();
    }
    public function index(Request $request)
    {
        if ($request->ajax()) {
            return DataTables::of(Protest::select(['protests.id','user_expert_id',
                DB::raw('concat(users.fname ," ",users.lname) as users_fullname ')
                ,'protests.description','protests.created_at','protests.updated_at'])
                ->join('users', 'protests.user_id', '=', 'users.id'))

                ->editColumn('user_expert_id', function($protest) {
                    $expert_id=$protest->userexpert->expert_id;
                    $user_id=Expert::where('id',$expert_id)->first()->user_id;
                    $user=User::find($user_id);
                    return $user->fname . ' ' . $user->lname;
                })
                ->addColumn('operation', function($protest){
                    return parent::redirectAction('list/delete?id='.$protest->id,'حذف','danger mr-1');
                })
                ->rawColumns(['operation'])
                ->make(true);
        }
        $object = 'اعتراضات';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' => 'users_fullname', 'name' => 'users.fname', 'title' => 'نام کاربر'])
            ->addColumn(['data' => 'users_fullname', 'name' => 'users.lname', 'title' => 'نام کاربر','class'=>'d-none'])
            ->addColumn(['data' => 'user_expert_id', 'name' => 'user_expert_id', 'title' => 'نام کارشناس'])
            ->addColumn(['data' => 'description', 'name' => 'description', 'title' => 'توضیحات'])
            ->addColumn(['data' => 'created_at', 'name' => 'created_at', 'title' => 'ثبت'])
            ->addColumn(['data' => 'updated_at', 'name' => 'updated_at', 'title' => 'ویرایش'])
            ->addColumn(['data' => 'operation', 'name' => 'operation', 'title' => 'عملیات']);
        return view('core::shared.datatable', compact(['html','object']));
    }
    /**
     * Remove the specified resource from storage.
     * @param Request $request
     * @return Response
     */
    public function destroy(Request $request)
    {
        Protest::find($request->id)->delete();
        return redirect('admin/protest/list');
    }
    /**
     * Remove the specified resource from storage.
     * @param Request $request
     * @return Response
     */
    public function delete(Request $request)
    {
        Protest::find($request->id)->delete();
        return response()->json([
            'data'  => true,
            'message'=>'ok',
            'status' => 200
        ]);
    }
    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function store(Request $request)
    {
        $protest=protest::create($request->all());
        return response()->json([
            'data'  => $protest,
            'message'=>'ok',
            'status' => 200
        ]);
    }
    /**
     * Update the specified resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function update(Request $request)
    {
        Protest::find(($request->id))->update($request->all());
        $data=Protest::find($request->id);
        return response()->json([
            'data'  => $data,
            'message'=>'ok',
            'status' => 200
        ]);
    }
    public function showAll()
    {
        $data=Protest::where('user_id',Auth::user()->id)->with('userexpert')->get();
        return response()->json([
            'data'  => $data,
            'message'=>'ok',
            'status' => 200
        ]);
    }
}
