<?php

namespace Modules\Expert\Entities;

use Elasticquent\ElasticquentTrait;
use Illuminate\Database\Eloquent\Model;
use Modules\Advertisement\Entities\Advertisement;
use Modules\Blog\Entities\Comment;
use Modules\Core\Entities\User;

class UserExpert extends Model
{
    use ElasticquentTrait;

    protected $table='user_expert';
    protected $fillable = ['user_id','expert_id','adv_id','status','description','content','done','time','point','comment'];
    protected $appends = ['user','expert','advertisement','comments'];
    public function getUserAttribute()
    {
       return $this->user()->first();
    }
    public function getCommentsAttribute()
    {
        return $this->comments()->orderBy('id','desc')->get();
    }
    public function getExpertAttribute()
    {
       return $this->expert()->first();
    }
    public function getAdvertisementAttribute()
    {
       return $this->advertisement()->first();
    }
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    public function expert()
    {
        return $this->belongsTo(Expert::class, 'expert_id');
    }
    public function advertisement()
    {
        return $this->belongsTo(Advertisement::class, 'adv_id');
    }
    public function protest()
    {
        return $this->hasMany(Protest::class, 'user_expert_id');
    }
    public function comments()
    {
        return $this->morphMany(Comment::class,'commentable');
    }
}
