<?php

namespace Modules\Expert\Entities;

use Elasticquent\ElasticquentTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Advertisement\Entities\Category;
use Modules\Core\Entities\City;
use Modules\Core\Entities\User;
use Modules\Expert\Http\Controllers\ExpertController;

class Expert extends Model
{
    use ElasticquentTrait;
    use SoftDeletes;
    protected $fillable = ['user_id','inbox','request','city_id','description','history','national_code','birthday'];
    protected $appends = ['user','categories'];


    public function getUserAttribute()
    {
       return $this->user()->first();
    }
    public function getCategoriesAttribute()
    {
        return $this->category()->get();
    }
    public function users()
    {
        return $this->belongsToMany(User::class ,'user_expert');
    }
    public function user()
    {
        return $this->belongsTo(User::class ,'user_id');
    }
    public function category()
    {
        return $this->belongsToMany(Category::class ,'category_expert');
    }
    public function city()
    {
        return $this->belongsTo(City::class,'city_id');
    }

    public $adminFields=[
        'user_id'=>[
            'type'=>'select',
            'fa_name'=>'کاربر',
            'col'=>12,
            'required'=>true,
            'data'=>ExpertController::class.'@users'
        ],
        'description'=>[
            'type'=>'string',
            'fa_name'=>'توضیحات',
            'col'=>6,
            'required'=>false,
            'data'=>[]
        ],
        'category_id[]'=>[
            'type'=>'multipleSelect',
            'fa_name'=>'دسته بندی',
            'col'=>12,
            'required'=>true,
            'data'=>ExpertController::class.'@categories'
        ],
        'inbox'=>[
            'type'=>'string',
            'fa_name'=>'inbox',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'request'=>[
            'type'=>'string',
            'fa_name'=>'تعداد درخواست',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'city_id'=>[
            'type'=>'cities',
            'fa_name'=>'شهر',
            'required'=>true,
            'data'=>[]
        ],
        'history'=>[
            'type'=>'string',
            'fa_name'=>'سابقه',
            'col'=>6,
            'required'=>false,
            'data'=>[]
        ],
        'national_code'=>[
            'type'=>'string',
            'fa_name'=>'کد ملی',
            'col'=>6,
            'required'=>false,
            'data'=>[]
        ],
        'birthday'=>[
            'type'=>'date',
            'fa_name'=>'تاریخ تولد',
            'required'=>false,
            'col'=>6,
            'data'=>[]
        ],

    ];

}
