<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProtestsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('protests', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('user_expert_id');
            $table->unsignedInteger('user_id');
            $table->string('description');
            $table->foreign('user_expert_id')->references('id')->on('user_expert')->onDelete('cascade');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('protests');
    }
}
