<?php

namespace Modules\Core\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Modules\Core\Entities\CustomNotification;
use Modules\Core\Entities\User;
use Yajra\DataTables\DataTables;
use Yajra\DataTables\Html\Builder;
use Nwidart\Modules\Facades\Module;

class CustomNotificationController extends BaseController
{
    protected $htmlBuilder;
    public function __construct(Builder $htmlBuilder)
    {
        $this->htmlBuilder = $htmlBuilder;
        $this->htmlBuilder->parameters([
            'paging' => true,
            'searching' => true,
            'info' => false,
            'searchDelay' => 350,
            'language' => [
                'url' => Module::asset('core:datatable.json')
            ],
        ]);
        Parent::__construct();
    }
    public function index(Request $request)
    {
        if($request->ajax()) {
            return DataTables::of(CustomNotification::select(['id','title','description','content', 'created_at', 'updated_at']))

                ->make(true);
        }
        $object = 'نوتیفیکیشن';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' => 'title', 'name' => 'title', 'title' => 'عنوان'])
            ->addColumn(['data' => 'description', 'name' => 'description', 'title' => 'توضیحات'])
//            ->addColumn(['data' => 'content', 'name' => 'content', 'title' => 'متن'])
            ->addColumn(['data' => 'created_at', 'name' => 'created_at', 'title' => 'ثبت'])
            ->addColumn(['data' => 'updated_at', 'name' => 'updated_at', 'title' => 'ویرایش']);
        return view('core::shared.datatable', compact(['html','object']));
    }
    /**
     * Show the form for creating a new resource.
     * @return Response
     */
    public function add()
    {
        $data['model'] = new CustomNotification();
        $data['route_action'] = 'core.custom.store';
        return view('core::shared.add',$data);
    }
    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function store(Request $request)
    {
        $custom=CustomNotification::create([
            'title' => $request->title,
            'content' => $request->get('content'),
            'description' =>$request->description,

        ]);
//        Parent::attachmentProcess($request,$custom);

        $c_custom=CustomNotification::find($custom->id);

        $results=User::all()->pluck('id');
        foreach ($results as $result){
            $c_user=User::find($result);
            User::find($result)->notify(new \Modules\Core\Notifications\CustomNotification($c_user,$c_custom));
//        $c_user->updatePushSubscription(
//            'https://fcm.googleapis.com/fcm/send/dc0K-ybcDRM:APA91bEUwaYPRaGYr4hy8F_tTMxRGM3Z67dVF3533ZAfaMl4twoZXzOQ69PUSg6P_jHKr3pZaxHDvVeXAgT9s5vNAr5jw4zYBkrNmY3yK--BjuIRDi1zJnyT82GZvzYW0HmalihIb8-H'
////            'BLaGTVKA0Mt1e-8J2vmNmR1qHXj3COWisdrLRLclSZhNPARtaRqjZ1MRdXnLJxEu0Y_cmv_qzrfZ3hna9W_3TxA',
////            'pdvyvMenaAv5Keb2fLFHww'
//        );

        }
        return redirect()->route('admin.core.custom');
    }

}
