<?php

namespace Modules\Core\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Modules\Core\Entities\City;
use Modules\Core\Entities\CityTranslation;
use Modules\Core\Entities\StateTranslation;

class CityController extends Controller
{
    public function state()
    {
        $data = StateTranslation::all();
        return response()->json([
            'data'  => $data,
            'message'=>'ok',
            'status' => 200
        ]);
    }
    public function getCities($id){
        $ids=City::where('state_id',$id)->pluck('id');
        $data=CityTranslation::whereIn('city_id',$ids)->get();
        return response()->json([
            'data' => $data,
            'message'=>'ok',
            'status' => 200
        ]);
    }
}
