<?php

namespace Modules\Core\Entities;

use Elasticquent\ElasticquentTrait;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Notifications\Notifiable;
use Laravel\Passport\HasApiTokens;
use Modules\Advertisement\Entities\Advertisement;
use Modules\Advertisement\Entities\Filter;
use Modules\Blog\Entities\Like;
use Modules\Core\Http\Controllers\UserRoleController;
use Modules\Expert\Entities\Expert;
use Modules\Shop\Entities\Shop;
use NotificationChannels\WebPush\HasPushSubscriptions;
use Spatie\Permission\Traits\HasRoles;

class User extends \App\User
{
    use SoftDeletes,HasRoles,Notifiable,HasPushSubscriptions,ElasticquentTrait,HasApiTokens;

    protected $fillable = ['fname','lname','email','password','remember_token','tell','mobile','city_id','activation_code','deleted_at', 'created_at', 'updated_at'];
    protected $appends = ['attachments'];
    protected $hidden = ['activation_code','password', 'remember_token','active','deleted_at'];

    public $adminFields=[
        'fname'=>[
            'type'=>'string',
            'fa_name'=>'نام',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'lname'=>[
            'type'=>'string',
            'fa_name'=>'نام خانوادگی',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'email'=>[
            'type'=>'string',
            'fa_name'=>'email',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'mobile'=>[
            'type'=>'string',
            'fa_name'=>'mobile',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'city_id'=>[
            'type'=>'cities',
            'fa_name'=>'شهر',
            'required'=>true,
            'data'=>[]
        ],
        'role_id'=>[
            'type'=>'select',
            'fa_name'=>'سطح دسترسی',
            'col'=>6,
            'required'=>false,
            'data'=>UserRoleController::class.'@roles'
        ],
    ];
    public function getAttachmentsAttribute()
    {
        if($this->attachments()){
            return $this->attachments()->orderBy('id','desc')->first();
        }else{
            return [];
        }
    }
    public function attachments()
    {
        return $this->morphMany(Attachment::class, 'attachmentable');
    }
    public function shop()
    {
        return $this->hasMany(Shop::class ,'user_id');
    }

    public function advertisement()
    {
        return $this->hasMany(Advertisement::class, 'user_id');
    }

    public function expert()
    {
        return $this->belongsToMany(Expert::class ,'user_expert');
    }
    public function city()
    {
        return $this->belongsTo(City::class,'city_id');
    }
    public function filter()
    {
        return $this->hasMany(Filter::class, 'user_id');
    }
    public function Likes()
    {
        return $this->hasMany(Like::class,'user_id');
    }
    public function AauthAcessToken(){
        return $this->hasMany('\App\OauthAccessToken');
    }

    public function receivesBroadcastNotificationsOn()
    {
        return 'users.'.$this->id;
    }
}
