<?php

namespace Modules\Core\Entities;

use Elasticquent\ElasticquentTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Core\Http\Controllers\SpecialUserController;

class SpecialUser extends Model
{
    use ElasticquentTrait;
    protected $table='special_users';

    protected $fillable = ['user_id'];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    public $adminFields=[
        'user_id'=>[
            'type'=>'select',
            'fa_name'=>'کاربر',
            'col'=>12,
            'required'=>true,
            'data'=>SpecialUserController::class.'@user'
        ],
    ];
}
