<?php

namespace Modules\Core\Entities;

use Illuminate\Database\Eloquent\Model;

class CustomNotification extends Model
{
    protected $fillable = ['title','description','content'];
    public $adminFields=[
        'image'=>[
            'type'=>'photo',
            'fa_name'=>'عکس ',
            'col'=>12,
            'required'=>false,
            'data'=>[]
        ],
        'title'=>[
            'type'=>'string',
            'fa_name'=>'تیتر ',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'description'=>[
            'type'=>'string',
            'fa_name'=>'توضیحات',
            'col'=>6,
            'required'=>false,
            'data'=>[]
        ],
        'content'=>[
            'type'=>'text',
            'fa_name'=>'متن',
            'col'=>6,
            'required'=>false,
            'data'=>[]
        ],
    ];

    public function attachments()
    {
        return $this->morphMany(Attachment::class, 'attachmentable');
    }
}
