<?php

namespace Modules\Core\Entities;

use Dimsav\Translatable\Translatable;
use Elasticquent\ElasticquentTrait;
use Illuminate\Database\Eloquent\Model;

class Country extends Model
{
    use Translatable;
    use ElasticquentTrait;

    protected $table = 'countries';

    public $translatedAttributes = [
        'title',
        'description',
    ];
    public $forms = [
        'title'=>['type'=>'admin.forms.text_nomodel_noform','config'=>['input_name' => 'title','input_title' => 'عنوان']],
        'description'=>['type'=>'admin.forms.textarea_desc_nomodel','config'=>['input_name' => 'description','input_title' => 'خلاصه']],
        'content'=>['type'=>'admin.forms.textarea_editor','config'=>['input_name' => 'content','input_title' => 'متن']],
        'seo_title'=>['type'=>'admin.forms.text_nomodel_noform','config'=>['input_name' => 'seo_title','input_title' => 'عنوان سئو']],
        'seo_description'=>['type'=>'admin.forms.textarea_desc_nomodel','config'=>['input_name' => 'seo_description','input_title' => 'توضیحات سئو']],
    ];

    protected $fillable = [
        'position',
        'display',
    ];


    function states() {
        return $this->hasMany(State::class,'country_id');
    }

//    function address(){
//        return $this->hasMany('App\UserAddress');
//    }

//    function logs(){
//        return $this->morphMany('App\LogAction','logable');
//    }




}
