<?php

namespace Modules\Core\Entities;


use Elasticquent\ElasticquentTrait;
use Illuminate\Database\Eloquent\Model;

class City extends Model
{
    use ElasticquentTrait;
    use \Dimsav\Translatable\Translatable;

    protected $table = 'cities';

    public $translatedAttributes = [
        'title',
        'description',
    ];
    protected $fillable = [
        'state_id',
        'position',
        'display',
        'featured',
    ];

    function state() {
        return $this->belongsTo(State::class);
    }

//    function area(){
//        return $this->hasMany('App\Area');
//    }
//
//    function address() {
//        return $this->hasMany('App\UserAddress');
//    }
//
//    function logs(){
//        return $this->morphMany('App\LogAction','logable');
//    }

}
