<?php

namespace Modules\Core\Entities;

use Elasticquent\ElasticquentTrait;
use Illuminate\Database\Eloquent\Model;

class Attachment extends Model
{
    use ElasticquentTrait;
    protected $fillable = ['attachmentable_id', 'attachmentable_type','mime', 'path', 'filename','uid', 'updated_at','created_at'];
    public $adminFields=[
        'logo'=>[
            'type'=>'photo',
            'fa_name'=>'لوگو ',
            'col'=>12,
            'required'=>false,
            'data'=>[]
        ],
        'image[]'=>[
            'type'=>'gallery',
            'fa_name'=>'عکس ها ',
            'col'=>12,
            'required'=>false,
            'data'=>[]
        ],
        'document[]'=>[
            'type'=>'gallery',
            'fa_name'=>'داکیومنت ',
            'col'=>12,
            'required'=>false,
            'data'=>[]
        ],
    ];
}
