@extends('core::layouts.master')
@section('head')


    <link href="{{Module::asset('core:node_modules/nestable/jquery-nestable.css')}}" rel="stylesheet"/>
    <link rel="stylesheet" href="{{Module::asset('core:node_modules/select2/dist/css/select2.min.css')}}"/>
    <link rel="stylesheet"
          href="{{Module::asset('core:node_modules/select2-bootstrap-theme/dist/select2-bootstrap.min.css')}}"/>
    <link rel="stylesheet" href="{{Module::asset('core:node_modules/icheck/skins/all.css')}}"/>
    <link rel="stylesheet"
          href="{{Module::asset('core:node_modules/jquery-tags-input/dist/jquery.tagsinput.min.css')}}">
    <link rel="stylesheet" href="{{Module::asset('core:node_modules/dropify/dist/css/dropify.min.css')}}">

@endsection
@section('content')
    <div class="content-wrapper">
        @include('core::layouts.breadcrumb')

        <div class="row">
            <div class="col-12 grid-margin">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6"><h4>افزودن بنر</h4></div>
                            <div class="col-md-6 text-left"><a href="/banner" class="btn btn-primary">بازگشت به لیست</a>
                            </div>
                        </div>
                        <form action="{{route('admin.'.$route_action)}}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                @foreach($model->adminFields as $index=>$item)
                                    @switch($item['type'])
                                    @case('photo')
                                    <div class="col-md-{{$item['col']}}">
                                        <div class="form-group pt-3">
                                            <label><span class="ml-1"
                                                         style="color: red;vertical-align: sub">*</span>{{$item['fa_name']}}
                                            </label>
                                            <div class="mt-1">
                                                <input name="{{$index}}" @if($item['required']) required @endif type="file" class="dropify"/>
                                            </div>
                                        </div>
                                    </div>
                                    @break
                                    @case('string')
                                    <div class="col-md-{{$item['col']}}">
                                        <div class="form-group pt-3">
                                            <label><span class="ml-1"
                                                         style="color: red;vertical-align: sub">*</span>{{$item['fa_name']}}
                                            </label>
                                            <input @if($item['required']) required @endif type="text" name="{{$index}}" class="form-control mt-1"
                                                   placeholder="{{$item['fa_name']}}">
                                        </div>
                                    </div>
                                    @break
                                    @case('boolean')
                                    <div class="col-md-{{$item['col']}}">
                                        <div class="form-group pt-3">
                                            <div class="mt-4">
                                                <label style="vertical-align: middle">{{$item['fa_name']}}</label>
                                                <label class="switch ml-3 pull-left" style="vertical-align: middle">
                                                    <input @if($item['required']) required @endif name="{{$index}}" type="checkbox" checked>
                                                    <span class="slider round"></span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    @break
                                    @case('text')
                                    <div class="col-md-{{$item['col']}}">
                                        <div class="form-group pt-3">
                                            <label for="xeditor">{{$item['fa_name']}}</label>
                                            <textarea @if($item['required']) required @endif name="{{$index}}" id="xeditor" rows="50" cols="80"></textarea>
                                        </div>
                                    </div>
                                    @break
                                    @case('radio')
                                    @foreach($item['data'] as $tmpIndex=>$name)
                                        <div class="col-sm-3 mt-1">
                                            <div class="icheck-square">
                                                <input @if($item['required']) required @endif tabindex="7" value="{{$tmpIndex}}" type="radio"
                                                       id="xradio{{$tmpIndex}}" name="{{$index}}">
                                                <label for="xradio{{$tmpIndex}}">{{$name}}</label>
                                            </div>
                                        </div>
                                    @endforeach
                                    @break
                                    @endswitch

                                @endforeach
                                <div class="col-md-12">
                                    <div class="form-group pt-5 text-left">
                                        <button type="submit" class="btn btn-success">ثبت</button>
                                        <button class="btn btn-danger">انصراف</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')

    <script src="{{Module::asset('core:node_modules/jquery-bar-rating/dist/jquery.barrating.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/raphael/raphael.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/jquery-sparkline/jquery.sparkline.min.js')}}"></script>
    <script src="{{Module::asset('core:js/jquery-sortable.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/nestable/jquery.nestable.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/select2/dist/js/select2.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/icheck/icheck.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/jquery-tags-input/dist/jquery.tagsinput.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/dropify/dist/js/dropify.min.js')}}"></script>
    <script src="{{Module::asset('core:ckeditor/ckeditor.js')}}"></script>
    <script src="{{Module::asset('core:js/iCheck.js')}}"></script>

    <script>
        swal({
            title: 'Error!',
            text: 'Do you want to continue',
            type: 'error',
            confirmButtonText: 'Cool'
        })
        CKEDITOR.replace('xeditor');
        $(function () {
            $(".js-example-basic-single").select2({dir: 'rtl', placeholder: "انتخاب نشده"});
            $('#editModal').on('shown.bs.modal', function (e) {
                $(".js-example-basic-single").select2({dir: 'rtl', placeholder: "انتخاب نشده"});
            })

            $('#tags').tagsInput({
                'width': '100%',
                'height': '100%',
                'interactive': true,
                'defaultText': 'اضافه کردن',
                'removeWithBackspace': true,
                'minChars': 0,
                'maxChars': 20, // if not provided there is no limit
                'placeholderColor': '#666666'
            });

            $('#tags2').tagsInput({
                'width': '100%',
                'height': '100%',
                'interactive': true,
                'defaultText': 'اضافه کردن',
                'removeWithBackspace': true,
                'minChars': 0,
                'maxChars': 20, // if not provided there is no limit
                'placeholderColor': '#666666'
            });
            $('.icon-plus').on('click', function () {
                $('.attachments').append('<div class="pt-3"> <input type="file" class="dropify" /></div>')
                $('.dropify').dropify();
            })
        });
    </script>
    <script src="{{Module::asset('core:/js/dropify.js')}}"></script>
@endsection