<?php

Route::group(['middleware' => ['web','auth','acl'], 'prefix' => 'admin','as' => 'admin'], function()
{
    Route::group(['middleware' => 'web', 'prefix' => 'blog', 'namespace' => 'Modules\Blog\Http\Controllers' , 'as'=>'.blog'], function()
    {
        Route::group(['middleware' => 'web', 'prefix' => 'list','as' => '.list' ], function()
        {
            Route::get('/', 'BlogController@index');
            Route::get('/delete','BlogController@destroy')->name('.delete');
            Route::get('/create','BlogController@add')->name('.create');
            Route::post('store', 'BlogController@store')->name('.store');
            Route::get('/edit','BlogController@edit')->name('.edit');
            Route::post('update/{id}', 'BlogController@update')->name('.update');
        });


        Route::group(['middleware' => 'web','prefix' => 'category' , 'as'=>'.category'], function()
        {
            Route::group([ 'prefix' => 'list','as' => '.list'], function()
            {
                Route::get('/', 'CategoryController@index');
                Route::get('/delete','CategoryController@destroy')->name('.delete');
                Route::get('/create','CategoryController@add')->name('.create');
                Route::post('store', 'CategoryController@store')->name('.store');
                Route::get('/edit','CategoryController@edit')->name('.edit');
                Route::post('update/{id}','CategoryController@update')->name('.update');
            });
        });
    });


});
//front-end routes
Route::group([ 'prefix' => 'blog', 'namespace' => 'Modules\Blog\Http\Controllers','middleware' => 'web'], function()
{
    Route::get('/search','BlogController@search');
    Route::post('/show','BlogController@show');
    Route::get('/show-all', 'BlogController@showAll')->name('.showAll');
    Route::get('/list','BlogController@list');
    Route::get('/category/show','CategoryController@show');
    Route::post('/category/blog','CategoryController@blog');
});

Route::middleware(['auth:api'])->group(function () {

    Route::group([ 'prefix' => 'blog', 'namespace' => 'Modules\Blog\Http\Controllers'], function(){
        Route::get('/liked','BlogController@getLikedBlog');
        Route::post('/like','BlogController@like');
    });
    Route::group([ 'prefix' => 'comment', 'namespace' => 'Modules\Blog\Http\Controllers'], function()
        {
            Route::post('/','BlogController@comment');
            Route::post('/comment/list','BlogController@commentList');
            Route::post('/comment/delete','BlogController@deleteComment');
        });
});