<?php

namespace Modules\Blog\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CreateBlog extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'description' => 'required',
            'title' => 'required',
            'seo-title' => 'required',
            'seo-description' => 'required',
            'content' => 'required',
            'category_id' => 'required',
            'display' => 'required',
            'image.*' => 'mimetypes:image/jpeg,image/png,image/jpg',
            'video.*' => 'mimetypes:video/mkv,video/mpeg,video/mp4',
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }
}
