<?php

namespace Modules\Blog\Entities;

use Elasticquent\ElasticquentTrait;
use Illuminate\Database\Eloquent\Model;
use Modules\Core\Entities\User;

class Comment extends Model
{
    use ElasticquentTrait;
    protected $fillable = ['comment','commentable_id', 'commentable_type', 'user_id', 'status','created_at', 'updated_at'];
    protected $appends = ['user'];

    public function getUserAttribute(){
        return $this->user()->first();
    }
    function commentable()
    {
        return $this->morphTo('commentable');
    }
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

}