<?php

namespace Modules\Auction\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\BroadcastMessage;
use Illuminate\Notifications\Notification;
use NotificationChannels\WebPush\WebPushChannel;
use NotificationChannels\WebPush\WebPushMessage;

class AuctionCreate extends Notification
{
    use Queueable;
    public $auction_id=null;
    public $auction_category_id=null;

    public function __construct($auction_id,$auction_category_id)
    {
        $this->auction_id=$auction_id;
        $this->auction_category_id=$auction_category_id;
    }
    /**
     * Get the notification's delivery channels.
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return [WebPushChannel::class,'database','broadcast'];
    }
    public function toWebPush($notifiable, $notification)
    {
        return (new WebPushMessage)
            ->title('New Advertisement!')
//            ->icon('/approved-icon.png')
            ->body('Your account was approved!')
            ->data(['id' => $notification->id,'auction_id'=>$this->auction_id ]);
//            ->action('View account', 'view_account');
    }
    public function toBroadcast($notifiable)
    {
        return new BroadcastMessage([
//            'user_id'=>$this->user->id,
            'auction_id'=>$this->auction_id,
            'auction_category_id'=>$this->auction_category_id
        ]);
    }
    public function toDatabase($notifiable)
    {
        return new BroadcastMessage([
//          'user_id'=>$this->user->id,
            'auction_id'=>$this->auction_id,
            'auction_category_id'=>$this->auction_category_id
        ]);
    }
}