<?php

namespace Modules\Auction\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Modules\Auction\Entities\Auction;
use Modules\Auction\Entities\AuctionCategory;

use Modules\Core\Http\Controllers\BaseController;
use Nwidart\Modules\Facades\Module;
use Yajra\DataTables\Html\Builder;
use Yajra\DataTables\DataTables;

class AuctioncategoryController extends BaseController
{
    protected $htmlBuilder;
    public function __construct(Builder $htmlBuilder)
    {
        $this->htmlBuilder = $htmlBuilder;
        $this->htmlBuilder->parameters([
            'paging' => true,
            'searching' => true,
            'info' => false,
            'searchDelay' => 350,
            'language' => [
                'url' => Module::asset('core:datatable.json')
            ],
        ]);
        Parent::__construct();
    }
    public function index(Request $request)
    {
        if ($request->ajax()) {
            return DataTables::of(AuctionCategory::select(['id','title','description', 'created_at', 'updated_at']))
                ->addColumn('operation', function($category) {
                    return parent::redirectAction('list/delete?id='.$category->id,'حذف','danger mr-1')
                        .parent::redirectAction('list/edit?id='.$category->id,'ویرایش','warning mr-1');
                })
                ->rawColumns(['operation'])
                ->make(true);
        }
        $object = 'دسته بندی مزایده ها';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' => 'title', 'name' => 'title', 'title' => 'عنوان'])
            ->addColumn(['data' => 'description', 'name' => 'description', 'title' => 'توضیحات'])
            ->addColumn(['data' => 'created_at', 'name' => 'created_at', 'title' => 'ثبت'])
            ->addColumn(['data' => 'updated_at', 'name' => 'updated_at', 'title' => 'ویرایش'])
            ->addColumn(['data' => 'operation', 'name' => 'operation', 'title' => 'عملیات']);

        return view('core::shared.datatable', compact(['html','object']));
    }
    /**
     * Show the form for creating a new resource.
     * @return Response
     */
    public function add()
    {
        $data['model'] = new AuctionCategory();
        $data['route_action'] = 'auction.category.list.store';
        return view('core::shared.add',$data);
    }
    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function store(Request $request)
    {
        $category=AuctionCategory::create([
            'title' => $request->title,
            'description' =>$request->description,
        ]);
        Parent::attachmentProcess($request,$category);

        return redirect()->route('admin.auction.category.list');
    }
    /**
     * Show the form for creating a new resource.
     * @param Request $request
     * @return Response
     */
    public function create(Request $request)
    {
        $cat=AuctionCategory::create([
            'title' => $request->title,
            'description' => $request->description,
        ]);
        return response()->json([
            'data' =>$cat,
            'message'=>'done',
            'status' => 200
        ]);
    }
    /**
     * Show the specified resource.
     * @return Response
     */
    public function show()
    {
        $list=AuctionCategory::orderBy('id','desc')->get();
        return response()->json([
            'data' =>$list,
            'message'=>'ok',
            'status' => 200
        ]);
    }
    /**
     * Show auction by category id.
     * @param Request $request
     * @return Response
     */
    public function blog(Request $request)
    {
        if($request->id){
            $list=AuctionCategory::find($request->id)->auction()->with('category')->orderBy('id','asc')->get();
        }else{
            $list=Auction::with('category')->get();
        }
        if($request->sort == 'hit'){
            $list=$list->sortBy('hit');
        }
        if($request->sort == 'like'){
            $list=$list->sortBy('likes');
        }
        $list=BaseController::paginateCollection($list,9,$request->page);
        return response()->json([
            'data' =>$list,
            'message'=>'ok',
            'status' => 200
        ]);
    }
    /**
     * Show the form for editing a new resource.
     * @param  Request $request
     * @return Response
     */
    public function edit(Request $request)
    {
        $data['route_action'] = 'auction.category.list.update';
        $data['data']=AuctionCategory::find($request->id);
        return view('core::shared.edit', $data);
    }
    /**
     * Update the specified resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function update(Request $request)
    {
        $cat = AuctionCategory::find(($request->id))->update($request->all());
        $data=AuctionCategory::find(($request->id));
        Parent::attachmentProcess($request,$data);

        return redirect()->route('admin.auction.category.list');
    }
    /**
     * Remove the specified resource from storage.
     * @param  Request $request
     * @return Response
     */
    public function destroy(Request $request)
    {
        AuctionCategory::find(($request->id))->delete();
        return redirect('admin/auction/category/list');
    }
}